/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.nisaba.util;

public class VectorUtilFloat {
    public static final float[] X_AXIS = new float[]{1.0f, 0.0f, 0.0f};
    public static final float[] Y_AXIS = new float[]{0.0f, 1.0f, 0.0f};
    public static final float[] Z_AXIS = new float[]{0.0f, 0.0f, 1.0f};
    public static final float[] vNull3 = new float[]{0.0f, 0.0f, 0.0f};

    private VectorUtilFloat() {
    }

    public static float distanceLinf(float[] a, float[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L inf distance");
        }
        float maxLength = 0.0f;
        float length = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            if (!((length += Math.abs(a[i] - b[i])) > maxLength)) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public static float distanceL2(float[] a, float[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L\u00d4\u00f8\u03a9 distance");
        }
        float sqrSum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sqrSum += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return (float)Math.sqrt(sqrSum);
    }

    public static float distanceL1(float[] a, float[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same length when computing L1 distance");
        }
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum += Math.abs(a[i] - b[i]);
        }
        return sum;
    }

    public static boolean compare(float[] a, float[] b, float tolerance) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static final void normalize3(float[] vector) {
        float norm = VectorUtilFloat.norm3(vector);
        if (norm == 1.0f) {
            return;
        }
        if (norm == 0.0f) {
            return;
        }
        VectorUtilFloat.div3(vector, norm);
    }

    public static final void normalize(float[] vector) {
        float norm = VectorUtilFloat.norm(vector);
        if (norm == 1.0f) {
            return;
        }
        if (norm == 0.0f) {
            return;
        }
        VectorUtilFloat.div(vector, norm);
    }

    public static final float normSqr(float[] vector) {
        float norm = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            norm += vector[i] * vector[i];
        }
        return norm;
    }

    public static final float norm(float[] vector) {
        return (float)Math.sqrt(VectorUtilFloat.normSqr(vector));
    }

    public static final float normSqr3(float[] vector) {
        float norm = 0.0f;
        for (int i = 0; i < 3; ++i) {
            norm += vector[i] * vector[i];
        }
        return norm;
    }

    public static final float norm3(float[] vector) {
        return (float)Math.sqrt(VectorUtilFloat.normSqr3(vector));
    }

    public static void dotProduct3(float[] a, float[] b, float[] result) {
        if (result == a || result == b) {
            throw new IllegalArgumentException("result cannot be one of the input vector");
        }
        result[0] = a[1] * b[2] - b[1] * a[2];
        result[1] = a[2] * b[0] - b[2] * a[0];
        result[2] = a[0] * b[1] - b[0] * a[1];
    }

    public static float[] dotProduct3(float[] a, float[] b) {
        return new float[]{a[1] * b[2] - b[1] * a[2], a[2] * b[0] - b[2] * a[0], a[0] * b[1] - b[0] * a[1]};
    }

    public static boolean isNull(float[] a, float tolerance) {
        return VectorUtilFloat.norm(a) < tolerance;
    }

    public static final float scalarProduct(float[] vectA, float[] vectB) {
        if (vectA.length != vectB.length) {
            throw new IllegalArgumentException("vectors must have the same size when computing the scalar product");
        }
        float scalarProduct = 0.0f;
        for (int i = 0; i < vectA.length; ++i) {
            scalarProduct += vectA[i] * vectB[i];
        }
        return scalarProduct;
    }

    public static final float[] add(float[] vectorResult, float[] vectorToAdd) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] + vectorToAdd[i];
        }
        return vectorResult;
    }

    public static final float[] minus(float[] vectorResult, float[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] - vector[i];
        }
        return vectorResult;
    }

    public static final float[] minusWithNew(float[] a, float[] b) {
        float[] vectorResult = new float[]{a[0], a[1], a[2]};
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] - b[i];
        }
        return vectorResult;
    }

    public static final float[] mult(float[] vectorResult, float[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] * vector[i];
        }
        return vectorResult;
    }

    public static final float[] div(float[] vectorResult, float[] vector) {
        int nb = vectorResult.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            vectorResult[n] = vectorResult[n] / vector[i];
        }
        return vectorResult;
    }

    public static final float[] add(float[] vectorResult, float valueToAdd) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] + valueToAdd;
        }
        return vectorResult;
    }

    public static final float[] minus(float[] vectorResult, float value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] - value;
        }
        return vectorResult;
    }

    public static final float[] mult(float[] vectorResult, float value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] * value;
        }
        return vectorResult;
    }

    public static final float[] div(float[] vectorResult, float value) {
        int i = 0;
        int nb = vectorResult.length;
        while (i < nb) {
            int n = i++;
            vectorResult[n] = vectorResult[n] / value;
        }
        return vectorResult;
    }

    public static final float[] div3(float[] vectorResult, float value) {
        int i = 0;
        while (i < 3) {
            int n = i++;
            vectorResult[n] = vectorResult[n] / value;
        }
        return vectorResult;
    }

    public static final float sum(float[] vector) {
        float value = 0.0f;
        int nb = vector.length;
        for (int i = 0; i < nb; ++i) {
            value += vector[i];
        }
        return value;
    }

    public static final float sum3(float[] vector) {
        float value = 0.0f;
        int nb = vector.length;
        for (int i = 0; i < nb; ++i) {
            value += vector[i];
        }
        return value;
    }

    public static final void sphericalToRectangularCoordinates(float[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("spherical coordinates cannot be null");
        }
        if (vector.length != 3) {
            throw new IllegalArgumentException("spherical coordinates must be 3D (not " + vector.length + "D)");
        }
        float rho = vector[0];
        float theta = vector[1];
        float phi = vector[2];
        float sinTheta = (float)Math.sin(theta);
        vector[0] = (float)((double)(rho * sinTheta) * Math.cos(phi));
        vector[1] = (float)((double)(rho * sinTheta) * Math.sin(phi));
        vector[2] = (float)((double)rho * Math.cos(theta));
    }

    public static final void rectangularToSphericalCoordinates(float[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("rectangular coordinates cannot be null");
        }
        if (vector.length != 3) {
            throw new IllegalArgumentException("rectangular coordinates must be 3D (not " + vector.length + "D)");
        }
        float EPSILON = 1.0E-7f;
        float x = vector[0];
        float y = vector[1];
        float z = vector[2];
        float rho = (float)Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        if (rho < 1.0E-7f) {
            vector[2] = 0.0f;
            vector[1] = 0.0f;
            vector[0] = 0.0f;
            return;
        }
        vector[0] = rho;
        if (Math.abs(z / rho) > 0.9999999f) {
            vector[1] = (float)(z < 0.0f ? Math.PI : 0.0);
            vector[2] = 0.0f;
        } else {
            vector[1] = (float)Math.acos(z / rho);
            vector[2] = (float)Math.atan2(y, x);
        }
    }

    public static final void copy(float[] src, float[] dest) {
        int nb = Math.min(src.length, dest.length);
        for (int i = 0; i < nb; ++i) {
            dest[i] = src[i];
        }
    }

    public static final void copy3(float[] src, float[] dest) {
        for (int i = 0; i < 3; ++i) {
            dest[i] = src[i];
        }
    }

    public static final float[] copy(float[] src) {
        if (src == null) {
            return null;
        }
        float[] dst = new float[src.length];
        VectorUtilFloat.copy(src, dst);
        return dst;
    }

    public static final float[] copy3(float[] src) {
        float[] dst = new float[3];
        VectorUtilFloat.copy3(src, dst);
        return dst;
    }

    public static float getAbsoluteMax(float[] array) {
        float max = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            max = Math.max(max, Math.abs(array[i]));
        }
        return max;
    }

    public static float getAbsoluteMin(float[] array) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            min = Math.min(min, Math.abs(array[i]));
        }
        return min;
    }

    public static boolean isInvalide(float[] array) {
        for (float value : array) {
            if (value != Float.NEGATIVE_INFINITY && value != Float.POSITIVE_INFINITY && !Float.isNaN(value)) continue;
            return true;
        }
        return false;
    }
}

