/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import vtk.vtkOOGLExporter;

public class ExportToOOGL
implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;
    private vtkOOGLExporter exporter;

    public ExportToOOGL(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        this.exporter = new vtkOOGLExporter();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".oogl");
            }

            @Override
            public String getDescription() {
                return "OOGL files";
            }
        });
        if (chooser.showSaveDialog(this.owner) == 0) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            try {
                if (!file.endsWith(".oogl")) {
                    file = file + ".oogl";
                }
                this.exporter.SetFileName(file);
                this.exporter.SetInput(this.pipelineManager.getCassandraView().GetRenderWindow());
                this.exporter.Update();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.owner, "Unable to save: " + file);
            }
        }
    }
}

