/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults.ui;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.defaults.ShowPickingInformation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class PickingInformationUI
extends PlugInControlUI {
    private static final long serialVersionUID = 8192426154264921709L;
    private PipeLineManager pipeLineManager;
    private ShowPickingInformation plugin;
    private JTextField pointPickerTolTextField;
    private JTextField cellPickerTolTextField;
    private JRadioButton pointModeButton;
    private JRadioButton cellModeButton;

    public PickingInformationUI(PipeLineManager pipeLineManager, ShowPickingInformation plugin, Frame owner) {
        super(owner, "Picking configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        JPanel pickingModePanel = new JPanel();
        pickingModePanel.setLayout(new BoxLayout(pickingModePanel, 2));
        pickingModePanel.setBorder(BorderFactory.createTitledBorder("Picking mode"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        this.pointModeButton = new JRadioButton("Point picking");
        buttonPanel.add(this.pointModeButton);
        this.cellModeButton = new JRadioButton("Cell picking");
        buttonPanel.add(this.cellModeButton);
        pickingModePanel.add(buttonPanel);
        pickingModePanel.add(Box.createHorizontalGlue());
        ButtonGroup group = new ButtonGroup();
        group.add(this.pointModeButton);
        group.add(this.cellModeButton);
        JPanel tolerancePanel = new JPanel();
        tolerancePanel.setLayout(new BoxLayout(tolerancePanel, 3));
        tolerancePanel.setBorder(BorderFactory.createTitledBorder("Picking tolerance"));
        JPanel pointPickerTolPanel = new JPanel();
        pointPickerTolPanel.setLayout(new BoxLayout(pointPickerTolPanel, 2));
        pointPickerTolPanel.add(new JLabel("Point picker tolerance:"));
        this.pointPickerTolTextField = new JTextField();
        pointPickerTolPanel.add(this.pointPickerTolTextField);
        tolerancePanel.add(pointPickerTolPanel);
        JPanel cellPickerTolPanel = new JPanel();
        cellPickerTolPanel.setLayout(new BoxLayout(cellPickerTolPanel, 2));
        cellPickerTolPanel.add(new JLabel("Cell picker tolerance:  "));
        this.cellPickerTolTextField = new JTextField();
        cellPickerTolPanel.add(this.cellPickerTolTextField);
        tolerancePanel.add(cellPickerTolPanel);
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        JPanel cmdLine = new JPanel();
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(pickingModePanel);
        this.getContentPane().add(tolerancePanel);
        this.getContentPane().add(Box.createVerticalGlue());
        this.getContentPane().add(new JSeparator());
        this.getContentPane().add(cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    public void setVisible(boolean b) {
        this.update();
        super.setVisible(b);
    }

    public void update() {
        int pickingMode = this.plugin.getPickingMode();
        if (pickingMode == 0) {
            this.pointModeButton.setSelected(true);
            this.cellModeButton.setSelected(false);
        } else if (pickingMode == 1) {
            this.pointModeButton.setSelected(false);
            this.cellModeButton.setSelected(true);
        }
        this.pointPickerTolTextField.setText(String.valueOf(this.plugin.getPointPickerTolerance()));
        this.cellPickerTolTextField.setText(String.valueOf(this.plugin.getCellPickerTolerance()));
    }

    private void updateModel() {
        if (this.pointModeButton.isSelected()) {
            this.plugin.setPickingMode(0);
        } else {
            this.plugin.setPickingMode(1);
        }
        this.plugin.setPointPickerTolerance(Double.valueOf(this.pointPickerTolTextField.getText()));
        this.plugin.setCellPickerTolerance(Double.valueOf(this.cellPickerTolTextField.getText()));
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("UPDATE")) {
            this.updateModel();
        } else if (cmd.equals("CANCEL")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public void itemStateChanged(ItemEvent arg0) {
    }
}

