/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field.data;

import com.artenum.penelope.field.data.AbstractDataArray;
import com.artenum.penelope.field.data.DataType;
import java.util.Arrays;
import java.util.List;

public class FloatDataArray
extends AbstractDataArray<Float> {
    private float[] data;

    public FloatDataArray() {
        this.nbData = 0;
        this.data = new float[40960];
    }

    public FloatDataArray(int size) {
        this.nbData = 0;
        this.data = new float[size];
    }

    public FloatDataArray(List<Float> data) {
        this.nbData = data.size();
        this.data = new float[data.size()];
        for (int index = 0; index < data.size(); ++index) {
            this.data[index] = data.get(index).floatValue();
        }
    }

    public FloatDataArray(float[] data) {
        this.data = data;
        this.nbData = data.length;
    }

    @Override
    public void set(int index, Float value) throws IndexOutOfBoundsException {
        this.data[index] = value.floatValue();
        if (index > this.currentLastIndex) {
            this.currentLastIndex = index;
        }
    }

    public boolean contains(float value) {
        for (int index = 0; index < this.currentLastIndex; ++index) {
            if (this.data[index] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(int index) throws IndexOutOfBoundsException {
        return Float.valueOf(this.data[index]);
    }

    public float getAsSimpleFloat(int index) throws IndexOutOfBoundsException {
        return this.data[index];
    }

    @Override
    public void add(Float value) {
        if (this.currentLastIndex > this.data.length - 1) {
            this.extendArraySize(this.data.length + 40960);
        }
        this.data[this.currentLastIndex] = value.floatValue();
        ++this.currentLastIndex;
        ++this.nbData;
    }

    @Override
    public void extendArraySize(int newSize) {
        System.out.println("In extendArraySize");
        if (newSize <= this.data.length) {
            return;
        }
        float[] newArray = new float[newSize];
        System.arraycopy(this.data, 0, newArray, 0, this.data.length);
        this.data = newArray;
    }

    @Override
    public void packArray() {
        float[] newArray = new float[this.nbData];
        System.arraycopy(this.data, 0, newArray, 0, this.nbData);
        this.data = newArray;
    }

    @Override
    public int getNbData() {
        return this.nbData;
    }

    @Override
    public int getArraySize() {
        return this.data.length;
    }

    @Override
    public int getDataDimension() {
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatDataArray other = (FloatDataArray)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }
}

