/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.element.AbstractEdge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Vertex;

public class Segment
extends AbstractEdge {
    public Segment(int uniqueId, Mesh aMesh, Vertex startVertex, Vertex endVertex) {
        super(uniqueId, aMesh, startVertex, endVertex);
    }

    public Segment(Mesh aMesh, Vertex startVertex, Vertex endVertex) {
        super(aMesh, startVertex, endVertex);
    }

    @Override
    public double getLength() {
        double length = 0.0;
        int spaceDimension = this.getVertexAt(0).getPoint().getSpaceDimension();
        for (int i = 0; i < this.getNbVertices() - 1; ++i) {
            Point startPoint = this.getVertexAt(i).getPoint();
            Point endPoint = this.getVertexAt(i + 1).getPoint();
            for (int j = 0; j < spaceDimension; ++j) {
                length += (endPoint.getCoord()[j] - startPoint.getCoord()[j]) * (endPoint.getCoord()[j] - startPoint.getCoord()[j]);
            }
        }
        return Math.sqrt(length);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" com.artenum.penelope.mesh.element.Segment(id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("), on vertices: ");
        boolean first = true;
        for (Vertex vertex : this.getVertices()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(vertex.getId());
        }
        return stringBuilder.toString();
    }
}

