/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.element.AbstractPolyhedron;
import com.artenum.penelope.mesh.element.Segment;
import com.artenum.penelope.mesh.element.Triangle;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Vertex;

public class Tetrahedron
extends AbstractPolyhedron {
    public Tetrahedron(int uniqueId, Mesh aMesh, Vertex firstVertex, Vertex secondVertex, Vertex thirdVertex, Vertex fourthVertex) {
        super(uniqueId, 6, 4, aMesh, firstVertex, secondVertex, thirdVertex, fourthVertex);
    }

    public Tetrahedron(Mesh aMesh, Vertex firstVertex, Vertex secondVertex, Vertex thirdVertex, Vertex fourthVertex) {
        super(6, 4, aMesh, firstVertex, secondVertex, thirdVertex, fourthVertex);
    }

    @Override
    public Face[] getFacesOnVertexAt(int vertexPosition) {
        Face[] faceList = new Face[3];
        switch (vertexPosition) {
            case 0: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(1);
                faceList[2] = this.getFaceAt(2);
                break;
            }
            case 1: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(1);
                faceList[2] = this.getFaceAt(3);
                break;
            }
            case 2: {
                faceList[0] = this.getFaceAt(1);
                faceList[1] = this.getFaceAt(2);
                faceList[2] = this.getFaceAt(3);
                break;
            }
            case 3: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(2);
                faceList[2] = this.getFaceAt(3);
                break;
            }
            default: {
                throw new RuntimeException("Node position outside the range");
            }
        }
        return faceList;
    }

    @Override
    public Face[] getFacesOnEdgeAt(int edgePosition) {
        Face[] faceList = new Face[2];
        switch (edgePosition) {
            case 0: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(1);
                break;
            }
            case 1: {
                faceList[0] = this.getFaceAt(1);
                faceList[1] = this.getFaceAt(3);
                break;
            }
            case 2: {
                faceList[0] = this.getFaceAt(1);
                faceList[1] = this.getFaceAt(2);
                break;
            }
            case 3: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(2);
                break;
            }
            case 4: {
                faceList[0] = this.getFaceAt(2);
                faceList[1] = this.getFaceAt(3);
                break;
            }
            case 5: {
                faceList[0] = this.getFaceAt(0);
                faceList[1] = this.getFaceAt(3);
                break;
            }
            default: {
                throw new RuntimeException("Node position outside the range");
            }
        }
        return faceList;
    }

    @Override
    public Edge[] getEdgesOfFaceAt(int facePosition) {
        Edge[] edgeList = new Edge[3];
        switch (facePosition) {
            case -1: {
                return new Edge[0];
            }
            case 0: {
                edgeList[0] = this.getEdgeAt(0);
                edgeList[1] = this.getEdgeAt(3);
                edgeList[2] = this.getEdgeAt(5);
                break;
            }
            case 1: {
                edgeList[0] = this.getEdgeAt(0);
                edgeList[1] = this.getEdgeAt(1);
                edgeList[2] = this.getEdgeAt(2);
                break;
            }
            case 2: {
                edgeList[0] = this.getEdgeAt(2);
                edgeList[1] = this.getEdgeAt(3);
                edgeList[2] = this.getEdgeAt(4);
                break;
            }
            case 3: {
                edgeList[0] = this.getEdgeAt(1);
                edgeList[1] = this.getEdgeAt(4);
                edgeList[2] = this.getEdgeAt(5);
                break;
            }
            default: {
                throw new RuntimeException("Face position outside the range");
            }
        }
        return edgeList;
    }

    @Override
    public int[] getVertexPositionsOnEdge(int edgePosition) {
        int[] positionsList = new int[2];
        switch (edgePosition) {
            case 0: {
                positionsList[0] = 0;
                positionsList[1] = 1;
                break;
            }
            case 1: {
                positionsList[0] = 1;
                positionsList[1] = 2;
                break;
            }
            case 2: {
                positionsList[0] = 2;
                positionsList[1] = 0;
                break;
            }
            case 3: {
                positionsList[0] = 3;
                positionsList[1] = 0;
                break;
            }
            case 4: {
                positionsList[0] = 3;
                positionsList[1] = 2;
                break;
            }
            case 5: {
                positionsList[0] = 3;
                positionsList[1] = 1;
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range");
            }
        }
        return positionsList;
    }

    public double getQuality(int qualityType) {
        switch (qualityType) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Math.pow(this.getVolume(), 0.6666666666666666) / this.getLength();
            }
            case 2: {
                return this.getShortestEdgeLength() / this.getLongestEdgeLength();
            }
        }
        throw new RuntimeException("Quality number outside the range " + qualityType);
    }

    public double getVolume() {
        double[] t = new double[3];
        double[] u = new double[3];
        double[] v = new double[3];
        double[] w = new double[3];
        u[0] = this.getVertexAt(1).getPoint().getCoord()[0] - this.getVertexAt(0).getPoint().getCoord()[0];
        u[1] = this.getVertexAt(1).getPoint().getCoord()[1] - this.getVertexAt(0).getPoint().getCoord()[1];
        u[2] = this.getVertexAt(1).getPoint().getCoord()[2] - this.getVertexAt(0).getPoint().getCoord()[2];
        v[0] = this.getVertexAt(2).getPoint().getCoord()[0] - this.getVertexAt(0).getPoint().getCoord()[0];
        v[1] = this.getVertexAt(2).getPoint().getCoord()[1] - this.getVertexAt(0).getPoint().getCoord()[1];
        v[2] = this.getVertexAt(2).getPoint().getCoord()[2] - this.getVertexAt(0).getPoint().getCoord()[2];
        t[0] = this.getVertexAt(3).getPoint().getCoord()[0] - this.getVertexAt(0).getPoint().getCoord()[0];
        t[1] = this.getVertexAt(3).getPoint().getCoord()[1] - this.getVertexAt(0).getPoint().getCoord()[1];
        t[2] = this.getVertexAt(3).getPoint().getCoord()[2] - this.getVertexAt(0).getPoint().getCoord()[2];
        w[0] = u[1] * v[2] - u[2] * v[1];
        w[1] = u[2] * v[0] - u[0] * v[2];
        w[2] = u[0] * v[1] - u[1] * v[0];
        double s = Math.sqrt(w[0] * w[0] + w[1] * w[1] + w[2] * w[2]) * 0.5;
        double h = w[0] * t[0] + w[1] * t[1] + w[2] * t[2];
        double V = s * (h /= s) / 3.0;
        return V /= 2.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" com.artenum.penelope.mesh.element.Tetrahedron(id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("), on vertices: ");
        boolean first = true;
        for (Vertex vertex : this.getVertices()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(vertex.getId());
        }
        return stringBuilder.toString();
    }

    @Override
    public Face getFaceAt(int facePosition) {
        Triangle face = null;
        switch (facePosition) {
            case 0: {
                face = new Triangle(this.getFaceIds()[facePosition], this.getMesh(), this.getVertexAt(0), this.getVertexAt(1), this.getVertexAt(3), this.getEdgeIds()[0], this.getEdgeIds()[5], this.getEdgeIds()[3]);
                break;
            }
            case 1: {
                face = new Triangle(this.getFaceIds()[facePosition], this.getMesh(), this.getVertexAt(0), this.getVertexAt(2), this.getVertexAt(1), this.getEdgeIds()[2], this.getEdgeIds()[1], this.getEdgeIds()[0]);
                break;
            }
            case 2: {
                face = new Triangle(this.getFaceIds()[facePosition], this.getMesh(), this.getVertexAt(0), this.getVertexAt(3), this.getVertexAt(2), this.getEdgeIds()[3], this.getEdgeIds()[4], this.getEdgeIds()[2]);
                break;
            }
            case 3: {
                face = new Triangle(this.getFaceIds()[facePosition], this.getMesh(), this.getVertexAt(1), this.getVertexAt(2), this.getVertexAt(3), this.getEdgeIds()[1], this.getEdgeIds()[4], this.getEdgeIds()[5]);
                break;
            }
            default: {
                throw new RuntimeException("Face number outside the range " + facePosition);
            }
        }
        return face;
    }

    @Override
    public Edge getEdgeAt(int position) {
        Segment edge = null;
        switch (position) {
            case 0: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(0), this.getVertexAt(1));
                break;
            }
            case 1: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(1), this.getVertexAt(2));
                break;
            }
            case 2: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(2), this.getVertexAt(0));
                break;
            }
            case 3: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(3), this.getVertexAt(0));
                break;
            }
            case 4: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(3), this.getVertexAt(2));
                break;
            }
            case 5: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(3), this.getVertexAt(1));
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range");
            }
        }
        return edge;
    }

    @Override
    public Edge[] getEdgesOnVertexAt(int position) {
        Edge[] edgeList = new Edge[3];
        switch (position) {
            case 0: {
                edgeList[0] = this.getEdgeAt(0);
                edgeList[1] = this.getEdgeAt(2);
                edgeList[2] = this.getEdgeAt(3);
                break;
            }
            case 1: {
                edgeList[0] = this.getEdgeAt(0);
                edgeList[1] = this.getEdgeAt(1);
                edgeList[2] = this.getEdgeAt(5);
                break;
            }
            case 2: {
                edgeList[0] = this.getEdgeAt(1);
                edgeList[1] = this.getEdgeAt(2);
                edgeList[2] = this.getEdgeAt(4);
                break;
            }
            case 3: {
                edgeList[0] = this.getEdgeAt(3);
                edgeList[1] = this.getEdgeAt(4);
                edgeList[2] = this.getEdgeAt(5);
                break;
            }
            default: {
                throw new RuntimeException("Node position outside the range");
            }
        }
        return edgeList;
    }

    @Override
    public Vertex[] getVerticesOnEdgeAt(int edgePosition) {
        Vertex[] idsList = new Vertex[2];
        switch (edgePosition) {
            case 0: {
                idsList[0] = this.getVertices()[0];
                idsList[1] = this.getVertices()[1];
                break;
            }
            case 1: {
                idsList[0] = this.getVertices()[1];
                idsList[1] = this.getVertices()[2];
                break;
            }
            case 2: {
                idsList[0] = this.getVertices()[2];
                idsList[1] = this.getVertices()[0];
                break;
            }
            case 3: {
                idsList[0] = this.getVertices()[3];
                idsList[1] = this.getVertices()[0];
                break;
            }
            case 4: {
                idsList[0] = this.getVertices()[3];
                idsList[1] = this.getVertices()[2];
                break;
            }
            case 5: {
                idsList[0] = this.getVertices()[3];
                idsList[1] = this.getVertices()[1];
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range");
            }
        }
        return idsList;
    }

    @Override
    public Vertex[] getVerticesOnFaceAt(int facePosition) {
        Vertex[] idsList = new Vertex[3];
        switch (facePosition) {
            case 0: {
                idsList[0] = this.getVertices()[0];
                idsList[1] = this.getVertices()[1];
                idsList[2] = this.getVertices()[3];
                break;
            }
            case 1: {
                idsList[0] = this.getVertices()[0];
                idsList[1] = this.getVertices()[2];
                idsList[2] = this.getVertices()[1];
                break;
            }
            case 2: {
                idsList[0] = this.getVertices()[0];
                idsList[1] = this.getVertices()[3];
                idsList[2] = this.getVertices()[2];
                break;
            }
            case 3: {
                idsList[0] = this.getVertices()[1];
                idsList[1] = this.getVertices()[2];
                idsList[2] = this.getVertices()[3];
                break;
            }
            default: {
                throw new RuntimeException("Face number outside of range");
            }
        }
        return idsList;
    }

    @Override
    public int[] getEdgeIdsOnFaceAt(int facePosition) {
        int[] idsList = new int[3];
        switch (facePosition) {
            case 0: {
                idsList[0] = this.getEdgeIds()[0];
                idsList[1] = this.getEdgeIds()[3];
                idsList[2] = this.getEdgeIds()[5];
                break;
            }
            case 1: {
                idsList[0] = this.getEdgeIds()[0];
                idsList[1] = this.getEdgeIds()[1];
                idsList[2] = this.getEdgeIds()[2];
                break;
            }
            case 2: {
                idsList[0] = this.getEdgeIds()[2];
                idsList[1] = this.getEdgeIds()[3];
                idsList[2] = this.getEdgeIds()[4];
                break;
            }
            case 3: {
                idsList[0] = this.getEdgeIds()[1];
                idsList[1] = this.getEdgeIds()[4];
                idsList[2] = this.getEdgeIds()[5];
                break;
            }
            default: {
                throw new RuntimeException("Face number outside of range");
            }
        }
        return idsList;
    }
}

