/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SingleEdgeIteratorFromVertexIds
implements Iterator<Edge> {
    private final Mesh mesh;
    private int[] vertexIds;
    private int currentPositionInVertexIds;
    private int currentPositionInEdgesOnVertex;
    private Edge currentEdge;
    private List<Edge> currentEdgesOnVertex;
    private Set<Integer> alreadyUsedEdgeIds;
    private boolean nextDone = true;

    public SingleEdgeIteratorFromVertexIds(Mesh mesh, int[] vertexIds) {
        this.mesh = mesh;
        this.vertexIds = vertexIds;
        this.alreadyUsedEdgeIds = new TreeSet<Integer>();
        this.currentPositionInVertexIds = 0;
        this.currentPositionInEdgesOnVertex = 0;
        if (vertexIds.length != 0) {
            int vertexId = vertexIds[0];
            this.currentEdgesOnVertex = this.mesh.getEdgesOnVertex(vertexId);
        } else {
            this.currentEdgesOnVertex = new ArrayList<Edge>();
        }
    }

    @Override
    public boolean hasNext() {
        boolean answer = true;
        boolean stopLoop = false;
        while (!stopLoop) {
            stopLoop = true;
            if (!this.nextDone) continue;
            if (this.currentPositionInVertexIds != this.vertexIds.length - 1) {
                if (this.currentPositionInEdgesOnVertex == this.currentEdgesOnVertex.size()) {
                    ++this.currentPositionInVertexIds;
                    int vertexId = this.vertexIds[this.currentPositionInVertexIds];
                    this.currentEdgesOnVertex = this.mesh.getEdgesOnVertex(vertexId);
                    this.currentPositionInEdgesOnVertex = 0;
                    if (this.currentEdgesOnVertex.size() != 0) {
                        this.currentEdge = this.currentEdgesOnVertex.get(this.currentPositionInEdgesOnVertex);
                    }
                    if (!(stopLoop = this.checkUnicity())) continue;
                    answer = this.confirmValidity();
                    continue;
                }
                this.currentEdge = this.currentEdgesOnVertex.get(this.currentPositionInEdgesOnVertex);
                ++this.currentPositionInEdgesOnVertex;
                stopLoop = this.checkUnicity();
                if (!stopLoop) continue;
                answer = this.confirmValidity();
                continue;
            }
            if (this.currentPositionInEdgesOnVertex == this.currentEdgesOnVertex.size()) {
                this.nextDone = false;
                answer = false;
                continue;
            }
            this.currentEdge = this.currentEdgesOnVertex.get(this.currentPositionInEdgesOnVertex);
            ++this.currentPositionInEdgesOnVertex;
            stopLoop = this.checkUnicity();
            if (!stopLoop) continue;
            answer = this.confirmValidity();
        }
        return answer;
    }

    private boolean checkUnicity() {
        boolean stopLoop = true;
        if (this.currentEdge != null && this.alreadyUsedEdgeIds.contains(this.currentEdge.getId())) {
            this.currentEdge = null;
            stopLoop = false;
        }
        return stopLoop;
    }

    private boolean confirmValidity() {
        boolean answer;
        if (this.currentEdge != null) {
            this.alreadyUsedEdgeIds.add(this.currentEdge.getId());
            this.nextDone = false;
            answer = true;
        } else {
            this.nextDone = false;
            answer = false;
        }
        return answer;
    }

    @Override
    public Edge next() {
        this.nextDone = true;
        return this.currentEdge;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
        this.vertexIds = null;
        this.currentEdgesOnVertex.clear();
        this.currentEdgesOnVertex = null;
        this.alreadyUsedEdgeIds.clear();
        this.alreadyUsedEdgeIds = null;
    }
}

