/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.splitting;

import com.artenum.nisaba.util.VectorUtilDouble;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.splitting.FaceMeshMaskSplitterWithoutContact;
import com.artenum.penelope.mesh.util.Barycentre;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FaceMeshMaskSplitterContact
extends FaceMeshMaskSplitterWithoutContact {
    public FaceMeshMaskSplitterContact(Mesh mesh) {
        super(mesh);
    }

    @Override
    public void splitMeshMask(MeshMask<Face> meshMask, int faceMeshMaskIdOutput, double xTranslation, double yTranslation, double zTranslation) {
        super.splitMeshMaskWithouFinalizeMesh(meshMask, faceMeshMaskIdOutput, xTranslation, yTranslation, zTranslation);
        Mesh mesh = super.getMesh();
        TreeSet<Integer> faceIdAttached = new TreeSet<Integer>();
        Map<Integer, Vertex> originalVertexIdToClone = this.getOriginalVertexIdToClone();
        double[] vectorFromVertexToBarycenter = new double[3];
        Point[] faceCoordinates = new Point[3];
        Set<Integer> originalVertexIdSet = originalVertexIdToClone.keySet();
        for (Integer originalVertexId : originalVertexIdSet) {
            Vertex currentVertex = mesh.getVertexById(originalVertexId);
            List<Face> facesOnVertex = mesh.getFacesOnVertex(originalVertexId);
            for (Face face : facesOnVertex) {
                int currentFaceId = face.getId();
                if (faceIdAttached.contains(currentFaceId)) continue;
                Vertex[] verticesInCurrentFace = face.getVertices();
                for (int vertexIndex = 0; vertexIndex < verticesInCurrentFace.length; ++vertexIndex) {
                    faceCoordinates[vertexIndex] = verticesInCurrentFace[vertexIndex].getPoint();
                }
                double[] computeIsoBaryCenter = Barycentre.computeIsoBaryCenter(faceCoordinates);
                vectorFromVertexToBarycenter[0] = computeIsoBaryCenter[0] - currentVertex.getPoint().getCoord()[0];
                vectorFromVertexToBarycenter[1] = computeIsoBaryCenter[1] - currentVertex.getPoint().getCoord()[1];
                vectorFromVertexToBarycenter[2] = computeIsoBaryCenter[2] - currentVertex.getPoint().getCoord()[2];
                Map<Integer, double[]> vertexNormalOfThinPlate = super.getVertexNormalOfThinPlate();
                double[] vertexNormal = vertexNormalOfThinPlate.get(originalVertexId);
                double scalarProduct = VectorUtilDouble.scalarProduct(vectorFromVertexToBarycenter, vertexNormal);
                if (scalarProduct < 0.0) {
                    for (int index = 0; index < face.getNbVertices(); ++index) {
                        Vertex vertexInsideDuplicatedFace;
                        if (!originalVertexIdSet.contains(face.getVertices()[index].getId())) continue;
                        face.getVertices()[index] = vertexInsideDuplicatedFace = originalVertexIdToClone.get(face.getVertices()[index].getId());
                    }
                }
                faceIdAttached.add(currentFaceId);
            }
        }
        mesh.finalizeMesh();
    }
}

