/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.util;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MeshAnalyser {
    public static ArrayList<Polyhedron> searchCellWithLowerQuality(Mesh mesh, int qualityType, double criticalQuality) {
        ArrayList<Polyhedron> result = new ArrayList<Polyhedron>();
        return result;
    }

    public static ArrayList<Polyhedron> searchCellWithHigherQuality(Mesh mesh, int qualityType, double criticalQuality) {
        ArrayList<Polyhedron> result = new ArrayList<Polyhedron>();
        return result;
    }

    public static List<Polyhedron> searchBorderPolyhedra(Mesh mesh) {
        ArrayList<Polyhedron> borderPolyhedra = new ArrayList<Polyhedron>();
        Iterator<Face> faceIterator = mesh.getFaceIterator();
        while (faceIterator.hasNext()) {
            Face currentFace = faceIterator.next();
            List<Polyhedron> polyhedraOnCurrentFace = mesh.getPolyhedraOnFace(currentFace.getId());
            if (polyhedraOnCurrentFace.size() != 1) continue;
            borderPolyhedra.addAll(polyhedraOnCurrentFace);
        }
        return borderPolyhedra;
    }

    public static List<Face> searchBorderFaces(Mesh mesh) {
        ArrayList<Face> borderFaces = new ArrayList<Face>();
        Iterator<Face> faceIterator = mesh.getFaceIterator();
        while (faceIterator.hasNext()) {
            Face currentFace = faceIterator.next();
            if (mesh.getPolyhedraOnFace(currentFace.getId()).size() != 1) continue;
            borderFaces.add(currentFace);
        }
        return borderFaces;
    }

    public static Set<MeshElement> searchBorderMeshElement(Mesh mesh) {
        int expectedElementDimension = mesh.getMeshDimension();
        int nbExpectedElement = expectedElementDimension - 1;
        TreeSet<MeshElement> result = new TreeSet<MeshElement>();
        int nbElement = 0;
        switch (expectedElementDimension) {
            case 3: {
                Iterator<Face> faceIterator = mesh.getFaceIterator();
                while (faceIterator.hasNext()) {
                    Face face = faceIterator.next();
                    nbElement = mesh.getPolyhedraOnFace(face.getId()).size();
                    if (nbElement == nbExpectedElement) continue;
                    for (Polyhedron polyherdon : mesh.getPolyhedraOnFace(face.getId())) {
                        result.add(polyherdon);
                    }
                }
                break;
            }
            case 2: {
                Iterator<Edge> edgeIterator = mesh.getEdgeIterator();
                while (edgeIterator.hasNext()) {
                    Edge edge = edgeIterator.next();
                    nbElement = mesh.getFacesOnEdge(edge.getId()).size();
                    if (nbElement == nbExpectedElement) continue;
                    for (Face faceTmp : mesh.getFacesOnEdge(edge.getId())) {
                        result.add(faceTmp);
                    }
                }
                break;
            }
            case 1: {
                Iterator<Vertex> vertexIterator = mesh.getVertexIterator();
                while (vertexIterator.hasNext()) {
                    Vertex vertex = vertexIterator.next();
                    nbElement = mesh.getEdgesOnVertex(vertex.getId()).size();
                    if (nbElement == nbExpectedElement) continue;
                    for (Edge edgeTmp : mesh.getEdgesOnVertex(vertex.getId())) {
                        result.add(edgeTmp);
                    }
                }
                break;
            }
        }
        return result;
    }
}

