/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutting;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.cutting.CuttingPlanePlugin;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import vtk.vtkDataSet;

public class CuttingPlaneControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private JFormattedTextField centerX;
    private JFormattedTextField centerY;
    private JFormattedTextField centerZ;
    private JFormattedTextField normalX;
    private JFormattedTextField normalY;
    private JFormattedTextField normalZ;
    private JComboBox input;
    private JSlider slider;
    private JCheckBox widgetCheckBox;
    private CuttingPlanePlugin plugin;

    public CuttingPlaneControlUI(PipeLineManager pipeLineManager, CuttingPlanePlugin plugin, Frame owner) {
        super(owner, "Cutting plane configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.input = new JComboBox(new DataSetListModel(pipeLineManager.getDataSetList()));
        DecimalFormat format = new DecimalFormat("#.###");
        this.centerX = new JFormattedTextField(format);
        this.centerX.setValue(new Double(0.0));
        this.centerY = new JFormattedTextField(format);
        this.centerY.setValue(new Double(0.0));
        this.centerZ = new JFormattedTextField(format);
        this.centerZ.setValue(new Double(0.0));
        this.normalX = new JFormattedTextField(format);
        this.normalX.setValue(new Double(0.0));
        this.normalY = new JFormattedTextField(format);
        this.normalY.setValue(new Double(0.0));
        this.normalZ = new JFormattedTextField(format);
        this.normalZ.setValue(new Double(1.0));
        JPanel grid = new JPanel(new GridLayout(3, 4));
        grid.add(new JLabel());
        grid.add(new JLabel("X"));
        grid.add(new JLabel("Y"));
        grid.add(new JLabel("Z"));
        grid.add(new JLabel("Center"));
        grid.add(this.centerX);
        grid.add(this.centerY);
        grid.add(this.centerZ);
        grid.add(new JLabel("Normal"));
        grid.add(this.normalX);
        grid.add(this.normalY);
        grid.add(this.normalZ);
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, 2));
        line1.add(new JLabel("Input Dataset"));
        line1.add(this.input);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        Hashtable<Integer, JLabel> label = new Hashtable<Integer, JLabel>();
        label.put(new Integer(-10), new JLabel("-1"));
        label.put(new Integer(10), new JLabel("1"));
        label.put(new Integer(0), new JLabel("0"));
        this.slider = new JSlider(-10, 10, 0);
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(10);
        this.slider.setLabelTable(label);
        this.slider.setPaintLabels(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener((ChangeListener)((Object)this));
        this.slider.setToolTipText("Translation based on center point with the normal vector has unit");
        JPanel widgetLine = new JPanel();
        widgetLine.setLayout(new BoxLayout(widgetLine, 2));
        widgetLine.add(Box.createHorizontalGlue());
        this.widgetCheckBox = new JCheckBox("Active 3D widget");
        this.widgetCheckBox.addItemListener((ItemListener)((Object)this));
        widgetLine.add(this.widgetCheckBox);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(line1);
        this.getContentPane().add(grid);
        this.getContentPane().add(this.slider);
        this.getContentPane().add(widgetLine);
        this.getContentPane().add(cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    public void update3DWidgetStatus() {
        this.plugin.show3DWidget(this.widgetCheckBox.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.widgetCheckBox) {
            this.plugin.show3DWidget(this.widgetCheckBox.isSelected());
        } else {
            System.out.println("Item not found");
        }
    }

    public void setSelectedInput(CassandraObject selectedInput) {
        if (selectedInput != null) {
            this.input.getModel().setSelectedItem(selectedInput);
        } else {
            System.out.println("Selection is null");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.input.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(new JFrame(), "Please select a valid input dataset.", "Input Filter Selection Error", 0);
                return;
            }
            this.slider.setValue(0);
            double cx = ((Number)this.centerX.getValue()).doubleValue();
            double cy = ((Number)this.centerY.getValue()).doubleValue();
            double cz = ((Number)this.centerZ.getValue()).doubleValue();
            double nx = ((Number)this.normalX.getValue()).doubleValue();
            double ny = ((Number)this.normalY.getValue()).doubleValue();
            double nz = ((Number)this.normalZ.getValue()).doubleValue();
            this.plugin.updateCuttingPlane(cx, cy, cz, nx, ny, nz, (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
            this.pipeLineManager.validateViewAndGo();
        }
        if (command.equals("CANCEL")) {
            this.plugin.show3DWidget(false);
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        double value = (double)this.slider.getValue() / 10.0;
        double cx = ((Number)this.centerX.getValue()).doubleValue();
        double cy = ((Number)this.centerY.getValue()).doubleValue();
        double cz = ((Number)this.centerZ.getValue()).doubleValue();
        double nx = ((Number)this.normalX.getValue()).doubleValue();
        double ny = ((Number)this.normalY.getValue()).doubleValue();
        double nz = ((Number)this.normalZ.getValue()).doubleValue();
        if (this.input.getSelectedItem() != null) {
            this.plugin.updateCuttingPlane(cx + nx * value, cy + ny * value, cz + nz * value, nx, ny, nz, (vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject());
            this.pipeLineManager.validateViewAndGo();
        }
    }

    public void setNormalFieldsValues(double[] normal) {
        this.normalX.setValue(new Double(normal[0]));
        this.normalY.setValue(new Double(normal[1]));
        this.normalZ.setValue(new Double(normal[2]));
    }

    public void setNormalFieldsValues(double nx, double ny, double nz) {
        this.normalX.setValue(nx);
        this.normalY.setValue(ny);
        this.normalZ.setValue(nz);
    }

    public void setOrigineFieldsValues(double[] origine) {
        this.centerX.setValue(new Double(origine[0]));
        this.centerY.setValue(new Double(origine[1]));
        this.centerZ.setValue(new Double(origine[2]));
    }

    public void setOrigineFieldsValues(double cx, double cy, double cz) {
        this.centerX.setValue(cx);
        this.centerY.setValue(cy);
        this.centerZ.setValue(cz);
    }

    class DataSetListModel
    implements ComboBoxModel {
        private VtkObjectListModel datasetModel;
        private Object selectedItem;

        public DataSetListModel(VtkObjectListModel datasetModel) {
            this.datasetModel = datasetModel;
        }

        @Override
        public Object getElementAt(int index) {
            return this.datasetModel.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.datasetModel.getSize();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.datasetModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.datasetModel.removeListDataListener(l);
        }
    }
}

