/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.ColorGradientSliderUI;
import com.artenum.tk.color.ColorGradientThumb;
import com.artenum.tk.color.IConfigurableLookupTable;
import com.artenum.tk.color.IGradientPanelListener;
import com.artenum.tk.color.ILookupTableListener;
import com.artenum.tk.color.IThumbPositionListener;
import com.artenum.tk.color.PopUpToolTip;
import com.artenum.tk.color.ThumbPositionEnum;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

public class ColorGradientSliderPanel
extends JPanel
implements IThumbPositionListener,
ILookupTableListener {
    private static final long serialVersionUID = -3655657226624986025L;
    private IConfigurableLookupTable lookupTable;
    private final List<ColorGradientThumb> thumbsList;
    private ColorGradientThumb selectedThumb;
    private JSlider slider;
    private ColorGradientSliderUI sliderUI;
    private final int orientation;
    private int thumbWidth;
    private int thumbHeight;
    private int nbTicks;
    private boolean thumbsVisible;
    private boolean tooltipVisible;
    private final CopyOnWriteArrayList<IGradientPanelListener> listeners;
    private final Runnable repaintRunnable;
    private final PopUpToolTip popUpToolTip = new PopUpToolTip(this);

    public ColorGradientSliderPanel(IConfigurableLookupTable aLookupTable) {
        this.thumbsList = new LinkedList<ColorGradientThumb>();
        this.listeners = new CopyOnWriteArrayList();
        this.lookupTable = aLookupTable;
        this.lookupTable.addLookupTableListener(this);
        this.orientation = 0;
        this.thumbWidth = 10;
        this.thumbHeight = 12;
        this.thumbsVisible = true;
        this.nbTicks = 11;
        this.repaintRunnable = new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.repaint();
            }
        };
        this.createThumbs();
        this.initSlider();
    }

    public void addListener(IGradientPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGradientPanelListener listener) {
        this.listeners.remove(listener);
    }

    public ColorGradientSliderPanel(IConfigurableLookupTable aLookupTable, int anOrientation) {
        this.thumbsList = new LinkedList<ColorGradientThumb>();
        this.listeners = new CopyOnWriteArrayList();
        this.lookupTable = aLookupTable;
        this.lookupTable.addLookupTableListener(this);
        this.orientation = anOrientation;
        this.thumbsVisible = true;
        this.nbTicks = 11;
        this.repaintRunnable = new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.repaint();
            }
        };
        if (this.orientation == 0) {
            this.thumbWidth = 10;
            this.thumbHeight = 12;
        } else {
            this.thumbWidth = 12;
            this.thumbHeight = 10;
        }
        this.createThumbs();
        this.initSlider();
    }

    private void initSlider() {
        this.slider = new JSlider(this.orientation);
        this.updateSlider();
        this.sliderUI = new ColorGradientSliderUI(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.setUI(ColorGradientSliderPanel.this.sliderUI);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.setPaintTicks(true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.setPaintLabels(true);
            }
        });
        this.add(this.slider);
    }

    private void createThumbs() {
        this.thumbsList.clear();
        for (Integer it : this.lookupTable.getColorPositionsMap().keySet()) {
            ThumbPositionEnum posEnum = it == 0 ? ThumbPositionEnum.START : (it == this.lookupTable.getNbColors() - 1 ? ThumbPositionEnum.END : ThumbPositionEnum.OTHER);
            ColorGradientThumb thumb = new ColorGradientThumb(posEnum, this.thumbWidth, this.thumbHeight, this.orientation);
            thumb.setColor(this.lookupTable.getColorPositionsMap().get(it));
            thumb.setColorIndex(it);
            thumb.setSelected(false);
            thumb.addColorIndexListener(this);
            this.thumbsList.add(thumb);
        }
    }

    public final int getNbThumbs() {
        return this.thumbsList.size();
    }

    public final Collection<ColorGradientThumb> getThumbs() {
        return this.thumbsList;
    }

    public final JSlider getSlider() {
        return this.slider;
    }

    public final ColorGradientSliderUI getSliderUI() {
        return this.sliderUI;
    }

    public final ColorGradientThumb getSelectedThumb() {
        return this.selectedThumb;
    }

    public final int getNbColors() {
        return this.lookupTable.getNbColors();
    }

    public final void setNbColors(int colors) {
        this.lookupTable.setNbColors(colors);
    }

    public final void setScalarRange(double min, double max) {
        this.lookupTable.setScalarRange(min, max);
    }

    public final double getScalarRangeMin() {
        return this.lookupTable.getMinScalarValue();
    }

    public final double getScalarRangeMax() {
        return this.lookupTable.getMaxScalarValue();
    }

    public final int getColorIndex(double value) {
        return this.lookupTable.getColorIndex(value);
    }

    public final Dimension getThumbsSize() {
        return new Dimension(this.thumbWidth, this.thumbHeight);
    }

    public final void setSelectedThumb(ColorGradientThumb aThumb) {
        if (this.selectedThumb != null) {
            this.selectedThumb.setSelected(false);
        }
        this.selectedThumb = aThumb;
        if (this.selectedThumb != null) {
            this.selectedThumb.setSelected(true);
            for (IGradientPanelListener listener : this.listeners) {
                listener.fixedColorSelected(this.selectedThumb.getColor(), this.selectedThumb.getColorIndex());
            }
        } else {
            for (IGradientPanelListener listener : this.listeners) {
                listener.fixedColorSelected(null, 0);
            }
        }
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final Color getColorAt(int position) {
        Color color = null;
        switch (this.orientation) {
            case 0: {
                color = this.lookupTable.getColorAt(this.sliderUI.valueForXPosition(position));
                break;
            }
            case 1: {
                color = this.lookupTable.getColorAt(this.sliderUI.valueForYPosition(position));
                break;
            }
        }
        return color;
    }

    @Override
    public final void colorIndexChanged(int oldPosition, int newPosition) {
        this.lookupTable.moveFixedColor(oldPosition, newPosition);
        if (this.tooltipVisible) {
            this.popUpToolTip.setText(String.valueOf(this.lookupTable.getValueAt(newPosition)));
            Point position = this.getLocationOnScreen();
            position.translate(this.getSelectedThumb().getLocation().x, this.getSelectedThumb().getLocation().y - 15);
            this.popUpToolTip.setPosition(position);
            this.popUpToolTip.setVisible(true);
        }
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    public void setLookupTable(IConfigurableLookupTable aLookupTable) {
        this.lookupTable.removeLookupTableListener(this);
        this.lookupTable = aLookupTable;
        this.lookupTable.addLookupTableListener(this);
        this.createThumbs();
        this.sliderUI.calculateThumbsLocation();
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    public final void addThumb(Color color, int position) {
        if (!this.getOccupiedPositions().contains(position)) {
            ColorGradientThumb thumb = new ColorGradientThumb(ThumbPositionEnum.OTHER, this.thumbWidth, this.thumbHeight, this.orientation);
            thumb.setColor(color);
            thumb.setColorIndex(position);
            thumb.setOrientation(this.orientation);
            thumb.setSelected(false);
            thumb.addColorIndexListener(this);
            this.thumbsList.add(thumb);
            this.lookupTable.addFixedColor(color, position);
            this.setSelectedThumb(thumb);
        } else {
            this.setFixedColorAt(position, color);
        }
    }

    public final void removeSelectedThumb() {
        if (this.selectedThumb.getPositionEnum() == ThumbPositionEnum.OTHER) {
            int colorIndex = this.selectedThumb.getColorIndex();
            this.selectedThumb.removeColorIndexListener(this);
            this.thumbsList.remove(this.selectedThumb);
            this.lookupTable.removeFixedColorAt(colorIndex);
            this.setSelectedThumb(null);
        }
    }

    public final boolean isThumbsVisible() {
        return this.thumbsVisible;
    }

    public final void setThumbsVisible(boolean visible) {
        this.thumbsVisible = visible;
    }

    public Collection<Integer> getOccupiedPositions() {
        return this.lookupTable.getColorPositionsMap().keySet();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.slider != null) {
            this.slider.setBackground(bg);
        }
    }

    public void setFixedColorAt(int position, Color newColor) {
        this.lookupTable.setColorAt(position, newColor);
        this.createThumbs();
        this.sliderUI.calculateThumbsLocation();
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    public final void setPaintLabels(boolean paint) {
        this.slider.setPaintLabels(paint);
    }

    public final void setPaintTicks(boolean paint) {
        this.slider.setPaintTicks(paint);
    }

    @Override
    public void fixedColorAdded(Color color, int position) {
        this.sliderUI.calculateThumbsLocation();
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    @Override
    public void fixedColorMoved(int oldPosition, int newPosition) {
        for (IGradientPanelListener listener : this.listeners) {
            listener.fixedColorMoved(oldPosition, newPosition);
        }
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    @Override
    public void fixedColorRemovedAt(int position) {
        this.createThumbs();
        this.sliderUI.calculateThumbsLocation();
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    @Override
    public void nbColorsChanged(int nbColor) {
        this.updateSlider();
        this.selectedThumb = null;
        this.createThumbs();
        this.sliderUI.calculateThumbsLocation();
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    @Override
    public void scalarRangeChanged(double min, double max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.updateSlider();
            }
        });
        SwingUtilities.invokeLater(this.repaintRunnable);
    }

    private void updateSlider() {
        final int nbColors = this.lookupTable.getNbColors();
        double tickSpacing = (double)(nbColors - 1) / (double)(this.nbTicks - 1);
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setGroupingSeparator(' ');
        unusualSymbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.#", unusualSymbols);
        final Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int colorIndex = 0;
        for (int i = 0; i < this.nbTicks; ++i) {
            colorIndex = (int)((double)i * tickSpacing);
            labelTable.put(colorIndex, new JLabel(format.format(this.lookupTable.getValueAt(colorIndex))));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, nbColors - 1);
                ColorGradientSliderPanel.this.slider.setModel(model);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderPanel.this.slider.setLabelTable(labelTable);
            }
        });
    }

    public int getNbTicks() {
        return this.nbTicks;
    }

    public void setNbTicks(int nbTicks) {
        this.nbTicks = nbTicks;
    }

    public void modificationEnded() {
        this.popUpToolTip.setVisible(false);
        for (IGradientPanelListener l : this.listeners) {
            l.modificationEnded();
        }
    }

    public void setToolTipVisible(boolean tooltipVisible) {
        this.tooltipVisible = tooltipVisible;
    }
}

