/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.IThumbPositionListener;
import com.artenum.tk.color.ThumbPositionEnum;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;

public class ColorGradientThumb
extends JComponent {
    private static final long serialVersionUID = -5778531799598999145L;
    private Color color;
    private Shape shape;
    private int colorIndex;
    private int orientation;
    private boolean isSelected;
    private BasicStroke stroke = new BasicStroke(2.0f);
    private CopyOnWriteArrayList<IThumbPositionListener> listeners = new CopyOnWriteArrayList();
    private int width;
    private int height;
    private ThumbPositionEnum positionEnum;

    public ColorGradientThumb(ThumbPositionEnum aPositionEnum, int aWidth, int aHeight, int anOrientation) {
        this.width = aWidth;
        this.height = aHeight;
        this.orientation = anOrientation;
        this.positionEnum = aPositionEnum;
        this.buildShape();
        this.colorIndex = 0;
        this.isSelected = false;
    }

    private void buildShape() {
        Polygon polygon = new Polygon();
        if (this.orientation == 0) {
            switch (this.positionEnum) {
                case START: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(0, this.height);
                    polygon.addPoint(this.width / 2, this.height / 2);
                    polygon.addPoint(this.width / 2, 0);
                    break;
                }
                case END: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(0, this.height / 2);
                    polygon.addPoint(this.width / 2, this.height);
                    polygon.addPoint(this.width / 2, 0);
                    break;
                }
                default: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(0, this.height / 2);
                    polygon.addPoint(this.width / 2, this.height);
                    polygon.addPoint(this.width, this.height / 2);
                    polygon.addPoint(this.width, 0);
                    break;
                }
            }
        } else {
            switch (this.positionEnum) {
                case START: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(this.width / 2, 0);
                    polygon.addPoint(this.width, this.height / 2);
                    polygon.addPoint(0, this.height / 2);
                    break;
                }
                case END: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(this.width, 0);
                    polygon.addPoint(this.width / 2, this.height / 2);
                    polygon.addPoint(0, this.height / 2);
                    break;
                }
                default: {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(this.width / 2, 0);
                    polygon.addPoint(this.width, this.height / 2);
                    polygon.addPoint(this.width / 2, this.height);
                    polygon.addPoint(0, this.height);
                }
            }
        }
        this.shape = polygon;
    }

    public final void addColorIndexListener(IThumbPositionListener listener) {
        this.listeners.add(listener);
    }

    public final void removeColorIndexListener(IThumbPositionListener listener) {
        this.listeners.remove(listener);
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color aColor) {
        this.color = aColor;
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(Shape aShape) {
        this.shape = aShape;
    }

    @Override
    public final Dimension getSize() {
        return this.shape.getBounds().getSize();
    }

    @Override
    public final Rectangle getBounds() {
        Rectangle bounds = this.shape.getBounds();
        bounds.setLocation(this.getLocation());
        return bounds;
    }

    public final int getColorIndex() {
        return this.colorIndex;
    }

    public final void setColorIndex(int index) {
        int oldPosition = this.colorIndex;
        this.colorIndex = index;
        for (IThumbPositionListener listener : this.listeners) {
            listener.colorIndexChanged(oldPosition, this.colorIndex);
        }
    }

    private Point getThumbPosition() {
        Point position = this.getLocation();
        if (this.orientation == 0) {
            switch (this.positionEnum) {
                case START: {
                    position.x += this.getBounds().width / 2;
                    break;
                }
                case END: {
                    position.x -= this.getBounds().width / 2;
                }
            }
        } else {
            switch (this.positionEnum) {
                case START: {
                    position.y -= this.getBounds().height / 2;
                    break;
                }
                case END: {
                    position.y += this.getBounds().height / 2;
                }
            }
        }
        return position;
    }

    @Override
    public final void paint(Graphics gIn) {
        Graphics2D g = (Graphics2D)gIn;
        Point position = this.getThumbPosition();
        g.translate(position.x, position.y);
        g.setColor(this.color);
        g.fill(this.shape);
        Stroke defaultStroke = g.getStroke();
        if (this.isSelected) {
            g.setColor(Color.BLACK);
            g.setStroke(this.stroke);
        } else {
            g.setColor(Color.GRAY);
            g.setStroke(defaultStroke);
        }
        g.draw(this.shape);
        g.setStroke(defaultStroke);
        g.translate(-position.x, -position.y);
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int anOrientation) {
        this.orientation = anOrientation;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public final ThumbPositionEnum getPositionEnum() {
        return this.positionEnum;
    }
}

