/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.IConfigurableLookupTable;
import com.artenum.tk.color.LookupTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ColorGradientView
extends JComponent
implements ListCellRenderer {
    private static final long serialVersionUID = 4016651671014455823L;
    private IConfigurableLookupTable lookupTable;
    private int prefWidth;
    private int prefHeight;
    private boolean isSelected = false;
    private BasicStroke stroke = new BasicStroke(2.0f);

    public ColorGradientView() {
        this.lookupTable = new LookupTable();
    }

    public ColorGradientView(int width, int height) {
        this.prefWidth = width;
        this.prefHeight = height;
        this.lookupTable = new LookupTable();
    }

    public ColorGradientView(IConfigurableLookupTable aLookupTable) {
        this.lookupTable = aLookupTable;
    }

    public ColorGradientView(IConfigurableLookupTable aLookupTable, int width, int height) {
        this.prefWidth = width;
        this.prefHeight = height;
        this.lookupTable = aLookupTable;
    }

    @Override
    public final Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        width = this.prefWidth != 0 ? this.prefWidth : this.getParent().getSize().width;
        height = this.prefHeight != 0 ? this.prefHeight : this.getParent().getSize().height;
        return new Dimension(width, height);
    }

    @Override
    public final Dimension getMaximumSize() {
        int width = 0;
        int height = 0;
        width = this.prefWidth != 0 ? this.prefWidth : this.getParent().getSize().width;
        height = this.prefHeight != 0 ? this.prefHeight : this.getParent().getSize().height;
        return new Dimension(width, height);
    }

    @Override
    public final Dimension getMinimumSize() {
        int width = 0;
        int height = 0;
        width = this.prefWidth != 0 ? this.prefWidth : this.getParent().getSize().width;
        height = this.prefHeight != 0 ? this.prefHeight : this.getParent().getSize().height;
        return new Dimension(width, height);
    }

    @Override
    protected final void paintComponent(Graphics gIn) {
        Graphics2D g = (Graphics2D)gIn;
        Rectangle bounds = this.getBounds();
        double minValue = this.lookupTable.getMinScalarValue();
        double maxValue = this.lookupTable.getMaxScalarValue();
        for (int i = 0; i < bounds.width; ++i) {
            double value = minValue + (double)i * (maxValue - minValue) / (double)bounds.width;
            g.setColor(this.lookupTable.getColor(value));
            g.drawLine(i, 0, i, bounds.height);
        }
        if (this.isSelected) {
            g.setColor(Color.BLACK);
            g.setStroke(this.stroke);
            g.drawRect(1, 1, bounds.width - 2, bounds.height - 2);
        } else {
            g.setColor(Color.WHITE);
            g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
        this.lookupTable = (IConfigurableLookupTable)value;
        this.isSelected = selected;
        return this;
    }
}

