/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class MapComboBoxModel<K, V>
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private Map<K, LinkedList<V>> data;
    private V selectedValue;
    private K selectedKey;

    public MapComboBoxModel(Map<K, LinkedList<V>> data) {
        this.data = data;
        if (data.size() > 0) {
            this.selectedKey = data.keySet().iterator().next();
            if (data.get(this.selectedKey).size() > 0) {
                this.selectedValue = data.get(this.selectedKey).get(0);
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedValue;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedValue = anItem;
    }

    @Override
    public Object getElementAt(int index) {
        return this.data.get(this.selectedKey).get(index);
    }

    @Override
    public int getSize() {
        if (this.selectedKey == null) {
            return 0;
        }
        return this.data.get(this.selectedKey).size();
    }

    public void addItem(V item) {
        if (item == null || this.selectedKey == null) {
            return;
        }
        this.data.get(this.selectedKey).add(item);
        this.update();
    }

    public void removeItem(V item) {
        this.data.get(this.selectedKey).remove(item);
        this.update();
    }

    public void update() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public List<V> getSelectedDataList() {
        return this.data.get(this.selectedKey);
    }

    public V getSelectedValue() {
        return this.selectedValue;
    }

    public void clear() {
        this.data.get(this.selectedKey).clear();
        this.update();
    }

    public void clearAll() {
        this.selectedKey = null;
        this.data.clear();
        this.update();
    }

    public void setSelectedKey(K newSelectedKey) {
        this.selectedKey = newSelectedKey;
        if (this.data.get(this.selectedKey) == null) {
            this.data.put(this.selectedKey, new LinkedList());
        }
        this.update();
    }

    public K getSelectedKey() {
        return this.selectedKey;
    }

    public Map<K, ? extends List<V>> getDataModel() {
        return this.data;
    }
}

