/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.impl;

import com.artenum.graph.impl.DefaultConnection;
import com.artenum.graph.impl.EmptyLayoutManager;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import com.artenum.graph.interfaces.GraphModel;
import com.artenum.graph.interfaces.GraphViewListener;
import com.artenum.graph.interfaces.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultGraphModel
implements GraphModel {
    protected ArrayList cellList = new ArrayList();
    protected ArrayList connectionList = new ArrayList();
    protected ArrayList viewListenerList = new ArrayList();
    protected LayoutManager layoutManager = new EmptyLayoutManager();

    public void insertCell(Cell cell) {
        this.cellList.add(cell);
        Iterator iterator = cell.getConnections().iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (this.connectionList.contains(connection)) continue;
            this.connectionList.add(connection);
        }
        iterator = this.viewListenerList.iterator();
        while (iterator.hasNext()) {
            ((GraphViewListener)iterator.next()).addCell(cell);
        }
    }

    public void removeCell(Cell cell) {
        this.cellList.remove(cell);
        Iterator iterator = cell.getConnections().iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            this.connectionList.remove(connection);
        }
        iterator = this.viewListenerList.iterator();
        while (iterator.hasNext()) {
            ((GraphViewListener)iterator.next()).removeCell(cell);
        }
    }

    public List getConnections() {
        return this.connectionList;
    }

    public List getCellList() {
        return this.cellList;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        layoutManager.setModel(this);
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void addViewListener(GraphViewListener graphViewListener) {
        this.viewListenerList.add(graphViewListener);
    }

    public void removeViewListener(GraphViewListener graphViewListener) {
        this.viewListenerList.remove(graphViewListener);
    }

    public void reload() {
        this.connectionList.clear();
        Iterator iterator = this.cellList.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            Iterator iterator2 = cell.getConnections().iterator();
            while (iterator2.hasNext()) {
                Connection connection = (Connection)iterator2.next();
                if (this.connectionList.contains(connection)) continue;
                this.connectionList.add(connection);
            }
        }
        iterator = this.viewListenerList.iterator();
        while (iterator.hasNext()) {
            ((GraphViewListener)iterator.next()).reload();
        }
    }

    public Connection connect(Cell cell, Cell cell2) {
        DefaultConnection defaultConnection = new DefaultConnection(cell, cell2);
        cell.addConnection(defaultConnection);
        cell2.addConnection(defaultConnection);
        this.connectionList.add(defaultConnection);
        Iterator iterator = this.viewListenerList.iterator();
        while (iterator.hasNext()) {
            ((GraphViewListener)iterator.next()).repaint();
        }
        return defaultConnection;
    }

    public void clear() {
        this.cellList.clear();
        this.connectionList.clear();
    }
}

