/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.listener;

import com.artenum.graph.interfaces.Cell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class SelectionListener
implements MouseMotionListener,
MouseListener {
    private JComponent baseComponent;
    private List cellList;
    private Stroke stroke;
    private Point startingPoint;
    private Point currentPoint;
    private boolean selecting = false;
    private Color bg = Color.WHITE;
    private Color fg = Color.BLACK;
    private Rectangle rectangle;

    public SelectionListener(JComponent jComponent, List list, Stroke stroke) {
        this.baseComponent = jComponent;
        this.cellList = list;
        this.stroke = stroke;
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.selecting) {
            this.startingPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.rectangle = this.computeRectangle();
            this.drawRect(this.fg, this.bg);
        }
        this.selecting = true;
        this.drawRect(this.fg, this.bg);
        this.currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.rectangle = this.computeRectangle();
        this.drawRect(this.bg, this.fg);
        Iterator iterator = this.cellList.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            Rectangle rectangle = cell.getUI().getBounds();
            cell.setSelected(this.rectangle.contains(rectangle));
        }
    }

    private Rectangle computeRectangle() {
        int n = Math.min(this.startingPoint.x, this.currentPoint.x);
        int n2 = Math.min(this.startingPoint.y, this.currentPoint.y);
        int n3 = Math.abs(this.startingPoint.x - this.currentPoint.x);
        int n4 = Math.abs(this.startingPoint.y - this.currentPoint.y);
        return new Rectangle(n, n2, n3, n4);
    }

    private void drawRect(Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)this.baseComponent.getGraphics();
        graphics2D.setColor(color);
        graphics2D.setXORMode(color2);
        graphics2D.setStroke(this.stroke);
        graphics2D.drawRect((int)this.rectangle.getX(), (int)this.rectangle.getY(), (int)this.rectangle.getWidth(), (int)this.rectangle.getHeight());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.selecting = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Iterator iterator = this.cellList.iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            cell.setSelected(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

