/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.launcher;

import com.artenum.cassandra.launcher.DynamicClassLoader;
import com.artenum.cassandra.launcher.PropertyLoader;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class Run {
    public static final String CASSANDRA_HOME = "cassandra.home";
    public static final String CASSANDRA_PREF_PUGIN_DIR = "cassandra.pref.plugin.dir";
    public static final String CASSANDRA_PREF_VTK_FILE_DIR = "cassandra.pref.vtk.file.dir";
    public static final String CASSANDRA_PREF_IMG_SAVE_DIR = "cassandra.pref.image.save.dir";
    public static final String CASSANDRA_PREF_SCRIPT_DIR = "cassandra.pref.script.dir";
    public static final String CASSANDRA_PREF_AUTO_UPDATE = "cassandra.pref.auto.update";

    public static void main(String[] args) throws Exception {
        System.out.println("Launcher starting... ");
        ArrayList<String> inputFileList = new ArrayList<String>();
        try {
            if (args.length > 0) {
                System.out.println("Loading properties file: " + args[0]);
                PropertyLoader.loadProperties(args[0]);
                for (int index = 1; index < args.length; ++index) {
                    String arg = args[index];
                    System.out.println(arg);
                    inputFileList.add(arg);
                }
            } else {
                System.out.println("Given properties file not found. Try to load the default properties file.");
                PropertyLoader.loadProperties("./config.properties");
            }
        }
        catch (Exception e) {
            System.err.println("Error impossible to load any property file.");
            e.printStackTrace();
        }
        if (System.getenv().get("CASSANDRA_HOME") != null) {
            System.setProperty(CASSANDRA_HOME, System.getenv().get("CASSANDRA_HOME"));
            System.out.println("cassandra.hoem set from the sytem to: " + System.getenv().get("CASSANDRA_HOME"));
        } else if (System.getProperty(CASSANDRA_HOME) != null) {
            System.out.println("cassandra.home set from the properties fiel to: " + System.getProperty(CASSANDRA_HOME));
        } else {
            System.out.println("cassandra.home not pre-set. Set to user.dir");
            System.setProperty(CASSANDRA_HOME, System.getProperty("user.dir"));
            System.out.println("cassandra.home arbitrary set to: " + System.getProperty(CASSANDRA_HOME));
        }
        HashMap<String, String> defaultPropertiesMap = new HashMap<String, String>();
        defaultPropertiesMap.put(CASSANDRA_PREF_PUGIN_DIR, System.getProperty(CASSANDRA_HOME) + File.separatorChar + "plugin");
        defaultPropertiesMap.put(CASSANDRA_PREF_VTK_FILE_DIR, System.getProperty(CASSANDRA_HOME) + File.separatorChar + "Data");
        defaultPropertiesMap.put(CASSANDRA_PREF_IMG_SAVE_DIR, System.getProperty(CASSANDRA_HOME) + File.separatorChar + "Views");
        defaultPropertiesMap.put(CASSANDRA_PREF_SCRIPT_DIR, System.getProperty(CASSANDRA_HOME) + File.separatorChar + "Script");
        defaultPropertiesMap.put(CASSANDRA_PREF_AUTO_UPDATE, "true");
        PropertyLoader.validateProperties(defaultPropertiesMap);
        for (String keyTmp : defaultPropertiesMap.keySet()) {
            System.out.println(keyTmp.toString() + "= " + System.getProperty(keyTmp));
        }
        String pathSep = System.getProperty("path.separator");
        if (System.getProperty("java.class.path") != null) {
            String[] classPath = System.getProperty("java.class.path").split(pathSep);
            File jarFile = null;
            for (int i = 0; i < classPath.length; ++i) {
                System.out.println("Add to classpath= " + System.getProperty(CASSANDRA_HOME) + File.separatorChar + classPath[i]);
                jarFile = new File(System.getProperty(CASSANDRA_HOME) + File.separatorChar + classPath[i]);
                DynamicClassLoader.getInstance().addJar(jarFile);
            }
        }
        Class cassandraClassLoader = DynamicClassLoader.getInstance().loadClass("com.artenum.cassandra.Cassandra");
        Object cassandra = cassandraClassLoader.newInstance();
        JFrame f = new JFrame("Cassandra VTK viewer");
        f.setJMenuBar((JMenuBar)cassandraClassLoader.getMethod("getDefaultMenu", new Class[0]).invoke(cassandra, new Object[0]));
        f.setDefaultCloseOperation(0);
        Class advancedWindowListenerClassLoader = DynamicClassLoader.getInstance().loadClass("com.artenum.cassandra.action.AdvancedWindowsEventListener");
        WindowListener winListener = (WindowListener)advancedWindowListenerClassLoader.newInstance();
        f.addWindowListener(winListener);
        f.getContentPane().add((Component)((JComponent)cassandraClassLoader.getMethod("getDefaultToolBar", new Class[0]).invoke(cassandra, new Object[0])), "North");
        f.getContentPane().add((Component)((JComponent)cassandraClassLoader.getMethod("getDefaultUI", new Class[0]).invoke(cassandra, new Object[0])), "Center");
        f.setSize(1024, 700);
        f.setLocationRelativeTo(null);
        if (System.getProperty(CASSANDRA_PREF_PUGIN_DIR) != null) {
            String plugInPath = "";
            if (System.getProperty(CASSANDRA_HOME) != null) {
                plugInPath = System.getProperty(CASSANDRA_HOME) + File.separatorChar;
            }
            plugInPath = plugInPath + System.getProperty(CASSANDRA_PREF_PUGIN_DIR);
            System.out.println("plugInPath =" + plugInPath);
            File pluginDir = new File(plugInPath);
            if (pluginDir.exists()) {
                cassandraClassLoader.getMethod("loadPluginInDirectory", File.class).invoke(cassandra, pluginDir);
            }
        }
        cassandraClassLoader.getMethod("setPreference", String.class, Object.class).invoke(cassandra, CASSANDRA_PREF_AUTO_UPDATE, System.getProperty(CASSANDRA_PREF_AUTO_UPDATE));
        String imagePath = "";
        if (System.getProperty(CASSANDRA_HOME) != null) {
            imagePath = System.getProperty(CASSANDRA_HOME) + File.separatorChar;
        }
        imagePath = imagePath + System.getProperty(CASSANDRA_PREF_IMG_SAVE_DIR);
        cassandraClassLoader.getMethod("setPreference", String.class, Object.class).invoke(cassandra, CASSANDRA_PREF_IMG_SAVE_DIR, new File(imagePath));
        cassandraClassLoader.getMethod("setPreference", String.class, Object.class).invoke(cassandra, CASSANDRA_PREF_PUGIN_DIR, new File(System.getProperty(CASSANDRA_PREF_PUGIN_DIR)));
        cassandraClassLoader.getMethod("setPreference", String.class, Object.class).invoke(cassandra, CASSANDRA_PREF_VTK_FILE_DIR, new File(System.getProperty(CASSANDRA_PREF_VTK_FILE_DIR)));
        String scriptPath = "";
        if (System.getProperty(CASSANDRA_HOME) != null) {
            scriptPath = System.getProperty(CASSANDRA_HOME) + File.separatorChar;
        }
        scriptPath = scriptPath + System.getProperty(CASSANDRA_PREF_SCRIPT_DIR);
        cassandraClassLoader.getMethod("setPreference", String.class, Object.class).invoke(cassandra, CASSANDRA_PREF_SCRIPT_DIR, new File(scriptPath));
        Object cassandraActionManager = cassandraClassLoader.getMethod("getActionManager", new Class[0]).invoke(cassandra, new Object[0]);
        cassandraActionManager.getClass().getMethod("setExitAction", DynamicClassLoader.getInstance().loadClass("com.artenum.cassandra.action.ExitAction")).invoke(cassandraActionManager, DynamicClassLoader.getInstance().loadClass("com.artenum.cassandra.action.ConfirmationSystemExit").newInstance());
        f.setVisible(true);
        for (String path : inputFileList) {
            System.out.println(path);
            File fileIn = new File(path);
            try {
                if (!fileIn.exists()) continue;
                cassandraClassLoader.getMethod("addVtkFile", File.class).invoke(cassandra, fileIn);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

