/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.dynamic.dataset;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.dynamic.dataset.DynamicDatasetControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class DynamicDatasetPlugin
extends Observable
implements CassandraPlugin,
RemoveListener {
    private String name = "Dynamic dataset";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private DynamicDatasetControlUI controlUI;
    private vtkDataSetReader dataSetVTK;
    private vtkDataSetMapper mapperVTK;
    private vtkActor actorVTK;
    private vtkLookupTable lookupTableVTK;
    private vtkScalarBarActor scalarBarVTK;
    private Filter filterImpl;
    private CassandraObject actor;
    private CassandraObject mapper;
    private CassandraObject dataset;
    private CassandraObject filter;
    private ArrayList<File> fileList;
    private File currentFile;

    public DynamicDatasetPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.fileList = new ArrayList();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".vtk");
            }

            @Override
            public String getDescription() {
                return "Vtk files";
            }
        });
        if (chooser.showOpenDialog(owner) != 0) {
            return;
        }
        this.fileList.add(chooser.getSelectedFile());
        this.dataSetVTK = new vtkDataSetReader();
        this.dataSetVTK.SetFileName(this.fileList.get(0).getAbsolutePath());
        this.dataSetVTK.Update();
        this.mapperVTK = new vtkDataSetMapper();
        this.mapperVTK.SetInput(this.dataSetVTK.GetOutput());
        this.mapperVTK.Update();
        this.actorVTK = new vtkActor();
        this.actorVTK.SetMapper((vtkMapper)this.mapperVTK);
        pipelineManager.addDataSet((Object)this.dataSetVTK.GetOutput(), "Dynamic");
        pipelineManager.addMapper((Object)this.mapperVTK, "");
        pipelineManager.setActorVisible(pipelineManager.addActor((Object)this.actorVTK, "Dynamic"), true);
        if (this.dataSetVTK.GetOutput().GetScalarRange() != null) {
            this.lookupTableVTK = new vtkLookupTable();
            this.lookupTableVTK.SetHueRange(0.66667, 0.0);
            this.lookupTableVTK.SetTableRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.lookupTableVTK.Build();
            this.mapperVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            this.mapperVTK.SetScalarRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.scalarBarVTK = new vtkScalarBarActor();
            this.scalarBarVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            pipelineManager.addLookupTable(this.lookupTableVTK, "Dynamic");
            pipelineManager.setActorVisible(pipelineManager.addScalarBar(this.scalarBarVTK, "Dynamic"), true);
        }
        this.filter = pipelineManager.addFilter(this.filterImpl, "Dynamic dataset");
        this.filterImpl.getOutputDataSet().add(this.dataSetVTK.GetOutput());
        pipelineManager.notifyConnectivityChange(this.filter);
        this.controlUI = new DynamicDatasetControlUI(pipelineManager, this, owner);
        this.controlUI.setCurrentDirectory(chooser.getSelectedFile().getParentFile());
        this.contextualMenu = new JPopupMenu("Movie menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicDatasetPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicDatasetPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
    }

    public ArrayList getVtkFileList() {
        return this.fileList;
    }

    public void showNextFile() {
        File f = null;
        f = this.currentFile != null ? (File)this.getVtkFileList().get((this.fileList.indexOf(this.currentFile) + 1) % this.fileList.size()) : (File)this.getVtkFileList().get(0);
        this.updateInputFile(f, this.controlUI.isSaveFileSelected());
    }

    public void setFirstFile(File firstFile) {
        this.fileList.clear();
        this.fileList.add(firstFile);
        this.updateInputFile(firstFile, this.controlUI.isSaveFileSelected());
        this.setChanged();
        this.notifyObservers();
    }

    public void addVtkFile(File f) {
        this.fileList.add(f);
        this.setChanged();
        this.notifyObservers();
    }

    public void updateInputFile(File vtkFile, boolean saveFile) {
        if (!vtkFile.exists()) {
            System.out.println("File not exist: " + vtkFile);
            return;
        }
        this.currentFile = vtkFile;
        this.dataSetVTK.SetFileName(vtkFile.getAbsolutePath());
        this.dataSetVTK.Update();
        this.pipelineManager.validateViewAndGo();
        if (saveFile) {
            this.pipelineManager.getCassandraView().saveToJPG(vtkFile.getAbsolutePath() + ".jpg");
        }
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

