/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ColorSaxHandler
extends DefaultHandler {
    public static final String ELEM_GRADIENT = "Gradient";
    public static final String ELEM_COLOR = "Color";
    public static final String ATTR_START_COLOR = "startColor";
    public static final String ATTR_END_COLOR = "endColor";
    public static final String ATTR_NB_COLORS = "nbColors";
    public static final String ATTR_POSITION = "position";
    public static final String ATTR_CODE = "code";
    private int nbColors;
    private Color startColor;
    private Color endColor;
    private Map<Integer, Color> intermediateColorsPositions = new HashMap<Integer, Color>();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(ELEM_GRADIENT)) {
            this.startColor = this.getColorAttribute(attributes, ATTR_START_COLOR);
            this.endColor = this.getColorAttribute(attributes, ATTR_END_COLOR);
            this.nbColors = this.getIntAttribute(attributes, ATTR_NB_COLORS);
        } else if (name.equals(ELEM_COLOR)) {
            int position = this.getIntAttribute(attributes, ATTR_POSITION);
            Color color = this.getColorAttribute(attributes, ATTR_CODE);
            this.intermediateColorsPositions.put(position, color);
        }
    }

    private Color getColorAttribute(Attributes attributes, String attributeName) {
        return Color.decode(attributes.getValue(attributeName));
    }

    private int getIntAttribute(Attributes attributes, String attributeName) {
        return Integer.parseInt(attributes.getValue(attributeName));
    }

    public int getNbColors() {
        return this.nbColors;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public Map<Integer, Color> getIntermediateColorsPositions() {
        return this.intermediateColorsPositions;
    }
}

