/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.sample;

import com.artenum.tk.ui.api.ListItem;
import com.artenum.tk.ui.file.SingleFileInput;
import com.artenum.tk.ui.list.ListItemBean;
import com.artenum.tk.ui.list.SingleSelectionInput;
import com.artenum.tk.ui.model.FileListenerPropertyModel;
import com.artenum.tk.ui.model.SingleSelectionListenerPropertyModel;
import com.artenum.tk.ui.util.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PropertyEditorSample {
    private File propertyFile;
    private Properties props = new Properties();
    private SingleFileInput filePath = new SingleFileInput();
    private SingleSelectionInput poolSize;
    private static final String PATH = "demo.dir";
    private static final String THREAD_POOL_SIZE = "demo.pool.size";

    public PropertyEditorSample() {
        this.filePath.addFileListener(new FileListenerPropertyModel(PATH, this.props));
        this.poolSize = new SingleSelectionInput("Number of thread in pool : ");
        ArrayList<ListItem> items = new ArrayList<ListItem>();
        items.add(new ListItemBean("2 threads", "2"));
        items.add(new ListItemBean("4 threads", "4"));
        items.add(new ListItemBean("8 threads", "8"));
        items.add(new ListItemBean("16 threads", "16"));
        items.add(new ListItemBean("32 threads", "32"));
        this.poolSize.setValues(items);
        this.poolSize.addSingleSelectionListener(new SingleSelectionListenerPropertyModel(THREAD_POOL_SIZE, this.props));
    }

    public PropertyEditorSample(String path) throws IOException {
        this();
        this.load(path);
    }

    public JComponent buildGUI() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.filePath.getUI());
        panel.add(this.poolSize.getUI());
        GuiHelper.fixHeight(panel.getComponents());
        return panel;
    }

    public void load(String path) throws IOException {
        this.propertyFile = new File(path);
        if (this.propertyFile.exists()) {
            FileInputStream fis = new FileInputStream(this.propertyFile);
            this.props.load(fis);
            fis.close();
            this.filePath.setValue(this.props.getProperty(PATH, ""), false);
            this.poolSize.setDefaultValue(this.props.getProperty(THREAD_POOL_SIZE, "2"));
        }
    }

    public void setPath(String path) {
        this.propertyFile = new File(path);
    }

    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.propertyFile);
        this.props.store(fos, "Sample demo");
        fos.close();
    }

    public static void main(String[] args) throws IOException {
        final PropertyEditorSample editor = new PropertyEditorSample(args.length > 0 ? args[0] : "configuration.txt");
        final JFrame frame = new JFrame("Demo property editor");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)editor.buildGUI(), "Center");
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    editor.save();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(frame, "An error occured while saving: " + e1.getMessage());
                }
            }
        });
        frame.getContentPane().add((Component)save, "South");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

