/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.model;

import com.artenum.tk.ui.api.FileListener;
import com.artenum.tk.ui.api.PropertiesListener;
import java.util.ArrayList;
import java.util.Properties;

public class FileListenerPropertyModel
implements FileListener {
    private Properties props;
    private String key;
    private ArrayList<PropertiesListener> listeners;

    public FileListenerPropertyModel(String key) {
        this(key, new Properties());
    }

    public FileListenerPropertyModel(String key, Properties propertyToUse) {
        this.props = propertyToUse;
        this.key = key;
        this.listeners = new ArrayList();
    }

    public Properties getProperties() {
        return this.props;
    }

    @Override
    public void valueChanged(String newValue) {
        this.props.setProperty(this.key, newValue);
        this.notifyListeners();
    }

    public void addPropertiesListener(PropertiesListener l) {
        this.listeners.add(l);
    }

    public void removePropertiesListener(PropertiesListener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners() {
        for (PropertiesListener l : this.listeners) {
            l.valueChanged(this.props);
        }
    }
}

