/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.defaults.VtkToolBox;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import vtk.vtkDataSet;

public class SaveDataSetToVtkFile
extends JDialog
implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;
    private JComboBox input;

    public SaveDataSetToVtkFile(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        super(owner, "Save to vtk file", true);
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
        this.input = new JComboBox(new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), null));
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, 2));
        line1.add(new JLabel("Input Dataset"));
        line1.add(this.input);
        JButton exec = new JButton("Select");
        exec.setActionCommand("SELECT");
        exec.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 2));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(line1);
        this.getContentPane().add(cmdLine);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SELECT")) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".vtk");
                }

                @Override
                public String getDescription() {
                    return "Vtk files";
                }
            });
            if (chooser.showSaveDialog(this.owner) == 0) {
                File vtkFile = chooser.getSelectedFile();
                this.dispose();
                VtkToolBox.writeVtkDataSetToFile((vtkDataSet)((CassandraObject)this.input.getSelectedItem()).getVtkObject(), vtkFile.getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        } else {
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }
}

