/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.util.Dichotomy;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataFieldManager {
    private final List<DataField<?, ?>> dataFields = new ArrayList();
    private final List<MeshMask<Vertex>> vertexMeshMasks = new ArrayList<MeshMask<Vertex>>();
    private final List<MeshMask<Edge>> edgeMeshMasks = new ArrayList<MeshMask<Edge>>();
    private final List<MeshMask<Face>> faceMeshMasks = new ArrayList<MeshMask<Face>>();
    private final List<MeshMask<Polyhedron>> polyhedronMeshMasks = new ArrayList<MeshMask<Polyhedron>>();
    private final TIntObjectMap<List<MeshMask<Vertex>>> meshMasksOnVertices = new TIntObjectHashMap<List<MeshMask<Vertex>>>();
    private final TIntObjectMap<List<MeshMask<Edge>>> meshMasksOnEdges = new TIntObjectHashMap<List<MeshMask<Edge>>>();
    private final TIntObjectMap<List<MeshMask<Face>>> meshMasksOnFaces = new TIntObjectHashMap<List<MeshMask<Face>>>();
    private final TIntObjectMap<List<MeshMask<Polyhedron>>> meshMasksOnPolyhedra = new TIntObjectHashMap<List<MeshMask<Polyhedron>>>();

    public List<DataField<?, ?>> getDataFields() {
        return this.dataFields;
    }

    public void addDataField(DataField<?, ?> dataField) {
        this.dataFields.add(dataField);
        switch (dataField.getMeshType()) {
            case VERTEX: {
                if (this.vertexMeshMasks.contains(dataField.getMeshMask())) break;
                this.vertexMeshMasks.add(dataField.getMeshMask());
                break;
            }
            case EDGE: {
                if (this.edgeMeshMasks.contains(dataField.getMeshMask())) break;
                this.edgeMeshMasks.add(dataField.getMeshMask());
                break;
            }
            case FACE: {
                if (this.faceMeshMasks.contains(dataField.getMeshMask())) break;
                this.faceMeshMasks.add(dataField.getMeshMask());
                break;
            }
            case POLYHEDRON: {
                if (this.polyhedronMeshMasks.contains(dataField.getMeshMask())) break;
                this.polyhedronMeshMasks.add(dataField.getMeshMask());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown DataField mesh type: " + (Object)((Object)dataField.getMeshType()));
            }
        }
    }

    public void removeDataField(DataField<?, ?> dataField) {
        this.dataFields.remove(dataField);
    }

    public void removeVertexMeshMaskIfNoDataField(final MeshMask<Vertex> meshMask) {
        List<DataField<?, Vertex>> dataFieldsOnMeshMask = meshMask.getDataFields();
        if (!dataFieldsOnMeshMask.isEmpty()) {
            this.vertexMeshMasks.remove(meshMask);
            this.meshMasksOnVertices.forEachEntry(new TIntObjectProcedure<List<MeshMask<Vertex>>>(){

                @Override
                public boolean execute(int key, List<MeshMask<Vertex>> value) {
                    boolean remove = value.remove(meshMask);
                    if (remove && value.isEmpty()) {
                        DataFieldManager.this.meshMasksOnVertices.remove(key);
                    }
                    return true;
                }
            });
        }
    }

    public void removeEdgeMeshMaskIfNoDataField(final MeshMask<Edge> meshMask) {
        List<DataField<?, Edge>> dataFieldsOnMeshMask = meshMask.getDataFields();
        if (!dataFieldsOnMeshMask.isEmpty()) {
            this.edgeMeshMasks.remove(meshMask);
            this.meshMasksOnEdges.forEachEntry(new TIntObjectProcedure<List<MeshMask<Edge>>>(){

                @Override
                public boolean execute(int key, List<MeshMask<Edge>> value) {
                    boolean remove = value.remove(meshMask);
                    if (remove && value.isEmpty()) {
                        DataFieldManager.this.meshMasksOnEdges.remove(key);
                    }
                    return true;
                }
            });
        }
    }

    public void removeFaceMeshMaskIfNoDataField(final MeshMask<Face> meshMask) {
        List<DataField<?, Face>> dataFieldsOnMeshMask = meshMask.getDataFields();
        if (!dataFieldsOnMeshMask.isEmpty()) {
            this.faceMeshMasks.remove(meshMask);
            this.meshMasksOnFaces.forEachEntry(new TIntObjectProcedure<List<MeshMask<Face>>>(){

                @Override
                public boolean execute(int key, List<MeshMask<Face>> value) {
                    boolean remove = value.remove(meshMask);
                    if (remove && value.isEmpty()) {
                        DataFieldManager.this.meshMasksOnFaces.remove(key);
                    }
                    return true;
                }
            });
        }
    }

    public void removePolyhedronMeshMaskIfNoDataField(final MeshMask<Polyhedron> meshMask) {
        List<DataField<?, Polyhedron>> dataFieldsOnMeshMask = meshMask.getDataFields();
        if (!dataFieldsOnMeshMask.isEmpty()) {
            this.polyhedronMeshMasks.remove(meshMask);
            this.meshMasksOnPolyhedra.forEachEntry(new TIntObjectProcedure<List<MeshMask<Polyhedron>>>(){

                @Override
                public boolean execute(int key, List<MeshMask<Polyhedron>> value) {
                    boolean remove = value.remove(meshMask);
                    if (remove && value.isEmpty()) {
                        DataFieldManager.this.meshMasksOnPolyhedra.remove(key);
                    }
                    return true;
                }
            });
        }
    }

    public DataField<?, ?> getDataFieldById(int id) {
        return Dichotomy.findIdentifiableById(this.dataFields, id);
    }

    public DataField<?, ?> getDataFieldByName(String name) {
        Iterator<DataField<?, ?>> dataFieldIter = this.dataFields.iterator();
        DataField<?, ?> tmpDataField = null;
        while (dataFieldIter.hasNext()) {
            tmpDataField = dataFieldIter.next();
            if (!tmpDataField.getName().equals(name)) continue;
            return tmpDataField;
        }
        return null;
    }

    public List<MeshMask<Vertex>> getVertexMeshMasksForVertexId(int vertexId) {
        List<MeshMask<Vertex>> list = this.meshMasksOnVertices.get(vertexId);
        if (list == null) {
            list = new ArrayList<MeshMask<Vertex>>();
        }
        return list;
    }

    public List<DataField<?, Vertex>> getDataFieldsForVertexId(int vertexId) {
        ArrayList datafieldsList = new ArrayList();
        for (MeshMask<Vertex> meshMask : this.getVertexMeshMasksForVertexId(vertexId)) {
            datafieldsList.addAll(meshMask.getDataFields());
        }
        return datafieldsList;
    }

    public List<MeshMask<Edge>> getEdgeMeshMasksForEdgeId(int edgeId) {
        List<MeshMask<Edge>> list = this.meshMasksOnEdges.get(edgeId);
        if (list == null) {
            list = new ArrayList<MeshMask<Edge>>();
        }
        return list;
    }

    public List<DataField<?, Edge>> getDataFieldsForEdgeId(int edgeId) {
        ArrayList datafieldsList = new ArrayList();
        for (MeshMask<Edge> meshMask : this.getEdgeMeshMasksForEdgeId(edgeId)) {
            datafieldsList.addAll(meshMask.getDataFields());
        }
        return datafieldsList;
    }

    public List<MeshMask<Face>> getFaceMeshMasksForFaceId(int faceId) {
        List<MeshMask<Face>> list = this.meshMasksOnFaces.get(faceId);
        if (list == null) {
            list = new ArrayList<MeshMask<Face>>();
        }
        return list;
    }

    public List<DataField<?, Face>> getDataFieldsForFaceId(int faceId) {
        ArrayList datafieldsList = new ArrayList();
        for (MeshMask<Face> meshMask : this.getFaceMeshMasksForFaceId(faceId)) {
            datafieldsList.addAll(meshMask.getDataFields());
        }
        return datafieldsList;
    }

    public List<MeshMask<Polyhedron>> getPolyhedronMeshMasksForPolyhedronId(int polyhedronId) {
        List<MeshMask<Polyhedron>> list = this.meshMasksOnPolyhedra.get(polyhedronId);
        if (list == null) {
            list = new ArrayList<MeshMask<Polyhedron>>();
        }
        return list;
    }

    public List<DataField<?, Polyhedron>> getDataFieldsForPolyhedronId(int polyhedronId) {
        ArrayList datafieldsList = new ArrayList();
        for (MeshMask<Polyhedron> meshMask : this.getPolyhedronMeshMasksForPolyhedronId(polyhedronId)) {
            datafieldsList.addAll(meshMask.getDataFields());
        }
        return datafieldsList;
    }

    public List<MeshMask<Vertex>> getVertexMeshMasks() {
        return this.vertexMeshMasks;
    }

    public List<MeshMask<Edge>> getEdgeMeshMasks() {
        return this.edgeMeshMasks;
    }

    public List<MeshMask<Face>> getFaceMeshMasks() {
        return this.faceMeshMasks;
    }

    public List<MeshMask<Polyhedron>> getPolyhedronMeshMasks() {
        return this.polyhedronMeshMasks;
    }

    public MeshMask<Vertex> getVertexMeshMaskById(int meshMaskId) {
        return Dichotomy.findIdentifiableById(this.vertexMeshMasks, meshMaskId);
    }

    public MeshMask<Edge> getEdgeMeshMaskById(int meshMaskId) {
        return Dichotomy.findIdentifiableById(this.edgeMeshMasks, meshMaskId);
    }

    public MeshMask<Face> getFaceMeshMaskById(int meshMaskId) {
        return Dichotomy.findIdentifiableById(this.faceMeshMasks, meshMaskId);
    }

    public MeshMask<Polyhedron> getPolyhedronMeshMaskById(int meshMaskId) {
        return Dichotomy.findIdentifiableById(this.polyhedronMeshMasks, meshMaskId);
    }

    public int addVertexMeshMask(MeshMask<Vertex> meshMaskToAdd) {
        this.vertexMeshMasks.add(meshMaskToAdd);
        return meshMaskToAdd.getId();
    }

    public int addEdgeMeshMask(MeshMask<Edge> meshMaskToAdd) {
        this.edgeMeshMasks.add(meshMaskToAdd);
        return meshMaskToAdd.getId();
    }

    public int addFaceMeshMask(MeshMask<Face> meshMaskToAdd) {
        this.faceMeshMasks.add(meshMaskToAdd);
        return meshMaskToAdd.getId();
    }

    public int addPolyhedronMeshMask(MeshMask<Polyhedron> meshMaskToAdd) {
        this.polyhedronMeshMasks.add(meshMaskToAdd);
        return meshMaskToAdd.getId();
    }

    public void addMeshMaskToVertexId(MeshMask<Vertex> meshMaskToAdd, int vertexId) {
        List<MeshMask<Vertex>> meshMasksList = this.meshMasksOnVertices.get(vertexId);
        if (meshMasksList == null) {
            meshMasksList = new ArrayList<MeshMask<Vertex>>();
            this.meshMasksOnVertices.put(vertexId, meshMasksList);
        }
        if (!meshMasksList.contains(meshMaskToAdd)) {
            meshMasksList.add(meshMaskToAdd);
        }
    }

    public void addMeshMaskToEdgeId(MeshMask<Edge> meshMaskToAdd, int edgeId) {
        List<MeshMask<Edge>> meshMasksList = this.meshMasksOnEdges.get(edgeId);
        if (meshMasksList == null) {
            meshMasksList = new ArrayList<MeshMask<Edge>>();
            this.meshMasksOnEdges.put(edgeId, meshMasksList);
        }
        if (!meshMasksList.contains(meshMaskToAdd)) {
            meshMasksList.add(meshMaskToAdd);
        }
    }

    public void addMeshMaskToFaceId(MeshMask<Face> meshMaskToAdd, int faceId) {
        List<MeshMask<Face>> meshMasksList = this.meshMasksOnFaces.get(faceId);
        if (meshMasksList == null) {
            meshMasksList = new ArrayList<MeshMask<Face>>();
            this.meshMasksOnFaces.put(faceId, meshMasksList);
        }
        if (!meshMasksList.contains(meshMaskToAdd)) {
            meshMasksList.add(meshMaskToAdd);
        }
    }

    public void addMeshMaskToPolyhedronId(MeshMask<Polyhedron> meshMaskToAdd, int polyhedronId) {
        List<MeshMask<Polyhedron>> meshMasksList = this.meshMasksOnPolyhedra.get(polyhedronId);
        if (meshMasksList == null) {
            meshMasksList = new ArrayList<MeshMask<Polyhedron>>();
            this.meshMasksOnPolyhedra.put(polyhedronId, meshMasksList);
        }
        if (!meshMasksList.contains(meshMaskToAdd)) {
            meshMasksList.add(meshMaskToAdd);
        }
    }

    public int getMaxVertexMeshMaskId() {
        int maxVertexMeshMaskId = Integer.MIN_VALUE;
        for (MeshMask<Vertex> vertexMeshMask : this.vertexMeshMasks) {
            if (maxVertexMeshMaskId >= vertexMeshMask.getId()) continue;
            maxVertexMeshMaskId = vertexMeshMask.getId();
        }
        return maxVertexMeshMaskId;
    }

    public int getMaxEdgeMeshMaskId() {
        int maxEdgeMeshMaskId = Integer.MIN_VALUE;
        for (MeshMask<Edge> edgeMeshMask : this.edgeMeshMasks) {
            if (maxEdgeMeshMaskId >= edgeMeshMask.getId()) continue;
            maxEdgeMeshMaskId = edgeMeshMask.getId();
        }
        return maxEdgeMeshMaskId;
    }

    public int getMaxFaceMeshMaskId() {
        int maxFaceMeshMaskId = Integer.MIN_VALUE;
        for (MeshMask<Face> faceMeshMask : this.faceMeshMasks) {
            if (maxFaceMeshMaskId >= faceMeshMask.getId()) continue;
            maxFaceMeshMaskId = faceMeshMask.getId();
        }
        return maxFaceMeshMaskId;
    }

    public int getMaxPolyhedronMeshMaskId() {
        int maxPolyhedronMeshMaskId = Integer.MIN_VALUE;
        for (MeshMask<Polyhedron> polyhedronMeshMask : this.polyhedronMeshMasks) {
            if (maxPolyhedronMeshMaskId >= polyhedronMeshMask.getId()) continue;
            maxPolyhedronMeshMaskId = polyhedronMeshMask.getId();
        }
        return maxPolyhedronMeshMaskId;
    }

    public void clear() {
        this.dataFields.clear();
        this.vertexMeshMasks.clear();
        this.edgeMeshMasks.clear();
        this.faceMeshMasks.clear();
        this.polyhedronMeshMasks.clear();
        this.meshMasksOnVertices.clear();
        this.meshMasksOnEdges.clear();
        this.meshMasksOnFaces.clear();
        this.meshMasksOnPolyhedra.clear();
    }
}

