/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field.data;

import com.artenum.penelope.field.data.AbstractDataArray;
import com.artenum.penelope.field.data.DataType;
import java.util.Arrays;
import java.util.List;

public class IntDataArray
extends AbstractDataArray<Integer> {
    private int[] data;

    public IntDataArray() {
        this.nbData = 0;
        this.data = new int[40960];
    }

    public IntDataArray(int size) {
        this.nbData = 0;
        this.data = new int[size];
    }

    public IntDataArray(int[] data) {
        this.nbData = data.length;
        this.data = data;
    }

    public IntDataArray(List<Integer> data) {
        this.nbData = data.size();
        this.data = new int[data.size()];
        for (int index = 0; index < data.size(); ++index) {
            this.data[index] = data.get(index);
        }
    }

    @Override
    public void set(int index, Integer value) {
        this.data[index] = value;
        if (index > this.currentLastIndex) {
            this.currentLastIndex = index;
        }
        this.nbData = Math.max(index + 1, this.nbData);
    }

    @Override
    public Integer get(int index) {
        return this.data[index];
    }

    public int getAsSimpleInt(int index) {
        return this.data[index];
    }

    @Override
    public void add(Integer value) {
        if (this.currentLastIndex > this.data.length - 1) {
            this.extendArraySize(this.data.length + 40960);
        }
        this.data[this.currentLastIndex] = value;
        ++this.currentLastIndex;
        ++this.nbData;
    }

    @Override
    public void extendArraySize(int newSize) {
        int[] newArray = new int[newSize];
        System.arraycopy(this.data, 0, newArray, 0, this.data.length);
        this.data = newArray;
    }

    @Override
    public void packArray() {
        int[] newArray = new int[this.nbData];
        System.arraycopy(this.data, 0, newArray, 0, this.nbData);
        this.data = newArray;
    }

    @Override
    public int getNbData() {
        return this.nbData;
    }

    @Override
    public int getArraySize() {
        return this.data.length;
    }

    @Override
    public int getDataDimension() {
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntDataArray other = (IntDataArray)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public DataType getDataType() {
        return DataType.INT;
    }
}

