/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.element.AbstractEdge;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.Arrays;

public abstract class AbstractFace
extends AbstractEdge
implements Face {
    private final int[] edgeIds;

    public AbstractFace(int uniqueId, int nbEdges, Mesh aMesh, Vertex ... vertexArray) {
        super(uniqueId, aMesh, vertexArray);
        this.edgeIds = new int[nbEdges];
        for (int i = 0; i < this.edgeIds.length; ++i) {
            this.edgeIds[i] = -1;
        }
    }

    public AbstractFace(int nbEdges, Mesh aMesh, Vertex ... vertexArray) {
        this(0, nbEdges, aMesh, vertexArray);
    }

    private double getLengthOfEdgeAt(int position) {
        return this.getEdgeAt(position).getLength();
    }

    @Override
    public double getLength() {
        double length = 0.0;
        for (int i = 0; i < this.getNbEdges() - 1; ++i) {
            length += this.getLengthOfEdgeAt(i);
        }
        return length;
    }

    @Override
    public int getSimplexDimension() {
        return 2;
    }

    @Override
    public MeshType getMeshType() {
        return MeshType.FACE;
    }

    @Override
    public int getNbEdges() {
        return this.getEdgeIds().length;
    }

    @Override
    public int getEdgePosition(int edgeId) {
        int position = -1;
        for (int i = 0; position == -1 && i < this.getEdgeIds().length; ++i) {
            if (this.getEdgeIds()[i] != edgeId) continue;
            position = i;
        }
        return position;
    }

    @Override
    public double getLongestEdgeLength() {
        double maxLength = 0.0;
        for (int i = 0; i < this.getEdgeIds().length; ++i) {
            maxLength = Math.max(maxLength, this.getLengthOfEdgeAt(i));
        }
        return maxLength;
    }

    @Override
    public double getShortestEdgeLength() {
        double minLength = 3.4028234663852886E38;
        for (int i = 0; i < this.getEdgeIds().length; ++i) {
            minLength = Math.min(minLength, this.getLengthOfEdgeAt(i));
        }
        return minLength;
    }

    @Override
    public int[] getEdgeIds() {
        return this.edgeIds;
    }

    @Override
    public Edge[] getEdges() {
        Edge[] edgeList = new Edge[this.getNbEdges()];
        for (int i = 0; i < edgeList.length; ++i) {
            edgeList[i] = this.getEdgeAt(i);
        }
        return edgeList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.edgeIds);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFace other = (AbstractFace)obj;
        return Arrays.equals(this.edgeIds, other.edgeIds);
    }
}

