/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.element.AbstractFace;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.Arrays;

public abstract class AbstractPolyhedron
extends AbstractFace
implements Polyhedron {
    private final int[] faceIds;

    public AbstractPolyhedron(int uniqueId, int nbEdges, int nbFaces, Mesh aMesh, Vertex ... vertexArray) {
        super(uniqueId, nbEdges, aMesh, vertexArray);
        this.faceIds = new int[nbFaces];
        for (int i = 0; i < this.faceIds.length; ++i) {
            this.faceIds[i] = -1;
        }
    }

    public AbstractPolyhedron(int nbEdges, int nbFaces, Mesh aMesh, Vertex ... vertexArray) {
        this(0, nbEdges, nbFaces, aMesh, vertexArray);
    }

    @Override
    public int getSimplexDimension() {
        return 3;
    }

    @Override
    public MeshType getMeshType() {
        return MeshType.POLYHEDRON;
    }

    @Override
    public int getFacePosition(int faceId) {
        int position = -1;
        for (int i = 0; position == -1 && i < this.faceIds.length; ++i) {
            if (this.faceIds[i] != faceId) continue;
            position = i;
        }
        return position;
    }

    @Override
    public int getNbFaces() {
        return this.faceIds.length;
    }

    @Override
    public Face[] getFaces() {
        Face[] faceList = new Face[this.getNbFaces()];
        for (int i = 0; i < faceList.length; ++i) {
            faceList[i] = this.getFaceAt(i);
        }
        return faceList;
    }

    @Override
    public double getLongestEdgeLength() {
        double maxLength = 0.0;
        for (Face face : this.getFaces()) {
            maxLength = Math.max(maxLength, face.getLongestEdgeLength());
        }
        return maxLength;
    }

    @Override
    public double getShortestEdgeLength() {
        double minLength = 3.4028234663852886E38;
        for (Face face : this.getFaces()) {
            minLength = Math.min(minLength, face.getShortestEdgeLength());
        }
        return minLength;
    }

    @Override
    public int[] getFaceIds() {
        return this.faceIds;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.faceIds);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPolyhedron other = (AbstractPolyhedron)obj;
        return Arrays.equals(this.faceIds, other.faceIds);
    }
}

