/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SingleFaceIteratorOnMesh
implements Iterator<Face> {
    private final Mesh mesh;
    private final Iterator<Face> faceMapIterator;
    private final Iterator<Face> cachedFaceMapIterator;
    private Face currentFace;
    private final Set<Integer> alreadyUsedFaceIds;
    private final TIntIterator faceIdsOfPolyhedraIterator;
    private boolean nextDone = true;

    public SingleFaceIteratorOnMesh(Mesh aMesh, TIntObjectHashMap<List<Polyhedron>> aPolyhedraOnFaceId, Map<Integer, Face> aFaceMap, Map<Integer, Face> aCachedFaceMap) {
        this.mesh = aMesh;
        this.faceMapIterator = aFaceMap.values().iterator();
        this.cachedFaceMapIterator = aCachedFaceMap.values().iterator();
        this.currentFace = null;
        this.alreadyUsedFaceIds = new TreeSet<Integer>();
        this.faceIdsOfPolyhedraIterator = aPolyhedraOnFaceId.keySet().iterator();
    }

    @Override
    public boolean hasNext() {
        boolean continueLoop = true;
        if (this.nextDone) {
            while (continueLoop) {
                Face face;
                continueLoop = false;
                if (this.faceIdsOfPolyhedraIterator.hasNext()) {
                    Integer faceId = this.faceIdsOfPolyhedraIterator.next();
                    if (!this.alreadyUsedFaceIds.contains(faceId)) {
                        this.currentFace = this.mesh.getFaceById(faceId);
                        this.alreadyUsedFaceIds.add(faceId);
                        this.nextDone = false;
                        continueLoop = false;
                        return true;
                    }
                    continueLoop = true;
                }
                if (this.faceMapIterator.hasNext()) {
                    face = this.faceMapIterator.next();
                    if (!this.alreadyUsedFaceIds.contains(face.getId())) {
                        this.currentFace = this.mesh.getFaceById(face.getId());
                        this.alreadyUsedFaceIds.add(face.getId());
                        this.nextDone = false;
                        continueLoop = false;
                        return true;
                    }
                    continueLoop = true;
                }
                if (!this.cachedFaceMapIterator.hasNext()) continue;
                face = this.cachedFaceMapIterator.next();
                if (!this.alreadyUsedFaceIds.contains(face.getId())) {
                    this.currentFace = this.mesh.getFaceById(face.getId());
                    this.alreadyUsedFaceIds.add(face.getId());
                    this.nextDone = false;
                    continueLoop = false;
                    return true;
                }
                continueLoop = true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public Face next() {
        Face answer = this.currentFace;
        this.nextDone = true;
        return answer;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

