/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SingleVertexIterator
implements Iterator<Vertex> {
    private final Set<Vertex> alreadyUsedVerticesIds;
    private Iterator<? extends Edge> meshElementIterator;
    private final int vertexCountInCurrentMeshElement;
    private Edge currentMeshElement;
    private int vertexPositionInCurrentMeshElement;
    private Vertex currentVertex;
    private boolean nextDone = true;

    public SingleVertexIterator(Iterator<? extends Edge> aMeshElementIterator) {
        this.meshElementIterator = aMeshElementIterator;
        if (!this.meshElementIterator.hasNext()) {
            this.vertexCountInCurrentMeshElement = 0;
        } else {
            this.currentMeshElement = this.meshElementIterator.next();
            this.vertexCountInCurrentMeshElement = this.currentMeshElement.getNbVertices();
            this.meshElementIterator = aMeshElementIterator;
        }
        this.alreadyUsedVerticesIds = new TreeSet<Vertex>();
        this.vertexPositionInCurrentMeshElement = 0;
    }

    @Override
    public boolean hasNext() {
        boolean answer = true;
        boolean stopLoop = false;
        while (!stopLoop) {
            stopLoop = true;
            if (this.nextDone) {
                if (this.computeIfHasNext()) {
                    if (this.vertexPositionInCurrentMeshElement == this.vertexCountInCurrentMeshElement) {
                        if (this.meshElementIterator.hasNext()) {
                            this.vertexPositionInCurrentMeshElement = 0;
                            this.currentMeshElement = this.meshElementIterator.next();
                            this.currentVertex = this.currentMeshElement.getVertexAt(this.vertexPositionInCurrentMeshElement);
                        }
                    } else {
                        this.currentVertex = this.currentMeshElement.getVertexAt(this.vertexPositionInCurrentMeshElement);
                        ++this.vertexPositionInCurrentMeshElement;
                    }
                    if (this.alreadyUsedVerticesIds.contains(this.currentVertex)) {
                        this.currentVertex = null;
                        stopLoop = false;
                    }
                    if (!stopLoop) continue;
                    if (this.currentVertex != null) {
                        this.alreadyUsedVerticesIds.add(this.currentVertex);
                        this.nextDone = false;
                        answer = true;
                        continue;
                    }
                    this.nextDone = false;
                    answer = false;
                    continue;
                }
                this.nextDone = false;
                answer = false;
                continue;
            }
            answer = true;
        }
        return answer;
    }

    private void computeNextUniqueVertexsave() {
        if (this.vertexPositionInCurrentMeshElement == this.vertexCountInCurrentMeshElement) {
            if (this.meshElementIterator.hasNext()) {
                this.vertexPositionInCurrentMeshElement = 0;
                this.currentMeshElement = this.meshElementIterator.next();
                this.currentVertex = this.currentMeshElement.getVertexAt(this.vertexPositionInCurrentMeshElement);
            }
        } else {
            this.currentVertex = this.currentMeshElement.getVertexAt(this.vertexPositionInCurrentMeshElement);
            ++this.vertexPositionInCurrentMeshElement;
        }
        if (this.alreadyUsedVerticesIds.contains(this.currentVertex)) {
            this.currentVertex = null;
            this.hasNext();
        }
    }

    private boolean computeIfHasNext() {
        boolean answer = !this.meshElementIterator.hasNext() ? this.vertexPositionInCurrentMeshElement != this.vertexCountInCurrentMeshElement : true;
        return answer;
    }

    @Override
    public Vertex next() {
        this.nextDone = true;
        return this.currentVertex;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

