/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.mask;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Identifiable;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMeshMask<T extends MeshElement>
implements MeshMask<T> {
    private int id;
    private String name;
    private String description = "";
    private final TIntArrayList meshElementIds;
    private final MeshType meshType;
    private final List<DataField<?, T>> datafields;
    private final Mesh mesh;

    public AbstractMeshMask(int id, String aName, String aDescription, Mesh aMesh, MeshType aMeshType) {
        this.id = id;
        this.meshElementIds = new TIntArrayList();
        this.meshType = aMeshType;
        this.datafields = new ArrayList();
        this.mesh = aMesh;
        this.name = aName;
        this.description = aDescription;
    }

    public AbstractMeshMask(int id, Mesh aMesh, MeshType aMeshType) {
        this(id, "", "", aMesh, aMeshType);
    }

    public AbstractMeshMask(Mesh aMesh, MeshType aMeshType) {
        this(-1, aMesh, aMeshType);
    }

    protected void addIdToMeshElementsList(int meshElementId) {
        this.meshElementIds.add(meshElementId);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String aDescription) {
        this.description = aDescription != null ? aDescription : "";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(Identifiable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return " [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", meshElementIds=" + this.meshElementIds + ", meshType=" + (Object)((Object)this.meshType) + "]";
    }

    @Override
    public String getMetaDataAsString() {
        return this.getId() + "\n" + this.getName() + "\n" + this.getDescription() + "\n" + (Object)((Object)this.getMeshType()) + "\n" + this.getNbMeshElements() + "\n" + "\n";
    }

    @Override
    public int[] getMeshElementIds() {
        return this.meshElementIds.toArray();
    }

    @Override
    public int getNbMeshElements() {
        return this.meshElementIds.size();
    }

    @Override
    public MeshType getMeshType() {
        return this.meshType;
    }

    @Override
    public List<DataField<?, T>> getDataFields() {
        return this.datafields;
    }

    @Override
    public void addDataField(DataField<?, T> datafieldToAdd) {
        this.datafields.add(datafieldToAdd);
    }

    @Override
    public Mesh getMesh() {
        return this.mesh;
    }

    public boolean isDataFieldValid(DataField<?, T> dataField) {
        return dataField.getMeshType() == this.getMeshType() && dataField.getNbMeshElements() == this.getNbMeshElements();
    }

    @Override
    public boolean containsMeshElementId(int elementId) {
        return this.meshElementIds.contains(elementId);
    }

    @Override
    public int indexOfMeshElementId(int elementId) {
        return this.meshElementIds.indexOf(elementId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.mesh == null ? 0 : this.mesh.hashCode());
        result = 31 * result + (this.meshElementIds == null ? 0 : this.meshElementIds.hashCode());
        result = 31 * result + (this.meshType == null ? 0 : this.meshType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMeshMask other = (AbstractMeshMask)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.mesh == null ? other.mesh != null : !this.mesh.equals(other.mesh)) {
            return false;
        }
        if (this.meshElementIds == null ? other.meshElementIds != null : !this.meshElementIds.equals(other.meshElementIds)) {
            return false;
        }
        if (this.meshType != other.meshType) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

