/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.splitting;

import com.artenum.nisaba.util.VectorUtilDouble;
import com.artenum.penelope.mesh.element.Node;
import com.artenum.penelope.mesh.element.Segment;
import com.artenum.penelope.mesh.element.Triangle;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.splitting.MeshMaskSplitter;
import com.artenum.penelope.mesh.splitting.OutputMeshSplitting;
import com.artenum.penelope.mesh.util.Barycentre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FaceMeshMaskSplitterWithoutContact
implements MeshMaskSplitter<Face> {
    private final Mesh mesh;
    private final Map<Integer, Edge> originalEdgeIdToClone;
    private final Map<Integer, Vertex> originalVertexIdToClone;
    private final Map<Integer, Face> originalFaceIdToClone;
    private final Map<Integer, double[]> triangleNormalOfThinPlate;
    private final Map<Integer, double[]> vertexNormalOfThinPlate;

    public FaceMeshMaskSplitterWithoutContact(Mesh mesh) {
        this.mesh = mesh;
        this.originalEdgeIdToClone = new HashMap<Integer, Edge>();
        this.originalVertexIdToClone = new HashMap<Integer, Vertex>();
        this.originalFaceIdToClone = new HashMap<Integer, Face>();
        this.triangleNormalOfThinPlate = new HashMap<Integer, double[]>();
        this.vertexNormalOfThinPlate = new HashMap<Integer, double[]>();
    }

    @Override
    public void splitMeshMask(MeshMask<Face> meshMask, int faceMeshMaskIdOutput, double xTranslation, double yTranslation, double zTranslation) {
        this.splitMeshMaskWithouFinalizeMesh(meshMask, faceMeshMaskIdOutput, xTranslation, yTranslation, zTranslation);
        this.mesh.finalizeMesh();
    }

    protected void splitMeshMaskWithouFinalizeMesh(MeshMask<Face> meshMask, int faceMeshMaskIdOutput, double xTranslation, double yTranslation, double zTranslation) {
        if (faceMeshMaskIdOutput == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("The mesh :\n" + this.mesh + "\n has no face mesh mask, but the mesh splitting is done on a face mesh mask defined in the mesh" + ", so there is a problem. The mesh must contain at least the face mesh mask :\n" + meshMask);
        }
        List<MeshMask<Face>> faceMeshMasks = this.mesh.getDataFieldManager().getFaceMeshMasks();
        for (MeshMask<Face> faceMeshMask : faceMeshMasks) {
            if (faceMeshMaskIdOutput != faceMeshMask.getId()) continue;
            throw new IllegalArgumentException("It is not possible to define a new mesh mask with the id : " + faceMeshMaskIdOutput + ", because a mesh mask with this id is already define in the mesh.");
        }
        FaceMeshMask newFaceMeshMask = new FaceMeshMask(faceMeshMaskIdOutput, this.mesh);
        this.duplicateMeshElements(meshMask, xTranslation, yTranslation, zTranslation, newFaceMeshMask);
        this.mesh.getDataFieldManager().addFaceMeshMask(newFaceMeshMask);
        this.computeNormalOfFace(meshMask, this.triangleNormalOfThinPlate);
        this.orientEdgesInTriangles(meshMask);
        this.computeNormalOfVertices(meshMask);
        this.computeConnectivityOfPolyhedraWithAtLeast1VertexOnThinPlate(meshMask);
        this.computeConnectivityOfPolyhedraWithAFaceOnThinPlate(meshMask);
    }

    protected void orientEdgesInTriangles(MeshMask<Face> originalMeshMask) {
        Iterator<Face> meshElementIterator = originalMeshMask.getMeshElementIterator();
        while (meshElementIterator.hasNext()) {
            Face face = meshElementIterator.next();
            double[] normalVector = this.triangleNormalOfThinPlate.get(face.getId());
            double[] oppositeNormalVector = new double[]{-normalVector[0], -normalVector[1], -normalVector[2]};
            this.checkNormalQuality(face, normalVector);
            Face duplicatedFace = this.originalFaceIdToClone.get(face.getId());
            this.checkNormalQuality(duplicatedFace, oppositeNormalVector);
        }
    }

    private void checkNormalQuality(Face face, double[] normalVector) {
        Vertex vertex0InOriginalTriangle = face.getVertexAt(0);
        Vertex vertex1InOriginalTriangle = face.getVertexAt(1);
        Vertex vertex2InOriginalTriangle = face.getVertexAt(2);
        double[] vector0 = new double[]{vertex1InOriginalTriangle.getPoint().getCoord()[0] - vertex0InOriginalTriangle.getPoint().getCoord()[0], vertex1InOriginalTriangle.getPoint().getCoord()[1] - vertex0InOriginalTriangle.getPoint().getCoord()[1], vertex1InOriginalTriangle.getPoint().getCoord()[2] - vertex0InOriginalTriangle.getPoint().getCoord()[2]};
        double[] vector1 = new double[]{vertex2InOriginalTriangle.getPoint().getCoord()[0] - vertex1InOriginalTriangle.getPoint().getCoord()[0], vertex2InOriginalTriangle.getPoint().getCoord()[1] - vertex1InOriginalTriangle.getPoint().getCoord()[1], vertex2InOriginalTriangle.getPoint().getCoord()[2] - vertex1InOriginalTriangle.getPoint().getCoord()[2]};
        double[] vector2 = new double[]{vertex0InOriginalTriangle.getPoint().getCoord()[0] - vertex2InOriginalTriangle.getPoint().getCoord()[0], vertex0InOriginalTriangle.getPoint().getCoord()[1] - vertex2InOriginalTriangle.getPoint().getCoord()[1], vertex0InOriginalTriangle.getPoint().getCoord()[2] - vertex2InOriginalTriangle.getPoint().getCoord()[2]};
        double[] normalBetweenVector0Vector1 = VectorUtilDouble.dotProduct(vector0, vector1);
        double[] normalBetweenVector1Vector2 = VectorUtilDouble.dotProduct(vector1, vector2);
        double[] normalBetweenVector2Vector0 = VectorUtilDouble.dotProduct(vector2, vector0);
        double scalarProductBetweenCurrentNormalComputed1ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector0Vector1, normalVector);
        double scalarProductBetweenCurrentNormalComputed2ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector1Vector2, normalVector);
        double scalarProductBetweenCurrentNormalComputed3ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector2Vector0, normalVector);
        if (scalarProductBetweenCurrentNormalComputed1ReferenceNormal < 0.0 || scalarProductBetweenCurrentNormalComputed2ReferenceNormal < 0.0 || scalarProductBetweenCurrentNormalComputed3ReferenceNormal < 0.0) {
            Edge previousEdge0 = face.getEdgeAt(0);
            Edge previousEdge1 = face.getEdgeAt(1);
            Edge previousEdge2 = face.getEdgeAt(2);
            Vertex tmpVertex = face.getVertices()[0];
            face.getVertices()[0] = face.getVertices()[1];
            face.getVertices()[1] = tmpVertex;
            Vertex[] vertices = new Vertex[]{face.getVertices()[0], face.getVertices()[1]};
            int edgeIdFromVertices = this.mesh.getEdgeIdFromVertices(vertices);
            Edge edgeById = this.mesh.getEdgeById(edgeIdFromVertices);
            Vertex tmpVertexId = edgeById.getVertices()[0];
            edgeById.getVertices()[0] = edgeById.getVertices()[1];
            edgeById.getVertices()[1] = tmpVertexId;
            Edge edge0AfterSwitch = face.getEdgeAt(0);
            Edge edge1AfterSwitch = face.getEdgeAt(1);
            Edge edge2AfterSwitch = face.getEdgeAt(2);
            if (previousEdge0.equals(edge0AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[1];
                face.getEdgeIds()[1] = face.getEdgeIds()[2];
                face.getEdgeIds()[2] = tmpEdgeId;
            } else if (previousEdge1.equals(edge1AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[0];
                face.getEdgeIds()[0] = face.getEdgeIds()[2];
                face.getEdgeIds()[2] = tmpEdgeId;
            } else if (previousEdge2.equals(edge2AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[0];
                face.getEdgeIds()[0] = face.getEdgeIds()[1];
                face.getEdgeIds()[1] = tmpEdgeId;
            } else {
                throw new UnsupportedOperationException("Switch of edge ids store in Face is not possible.");
            }
        }
    }

    @Override
    public OutputMeshSplitting createDataFields(MeshMask<Face> meshMask) {
        OutputMeshSplitting answer = this.computeFrontOfMeshElementAdded(meshMask);
        return answer;
    }

    private OutputMeshSplitting computeFrontOfMeshElementAdded(MeshMask<Face> meshMask) {
        HashMap<Integer, Face> originalFaceIdToDuplicatedFace = new HashMap<Integer, Face>();
        HashMap<Integer, Edge> originalEdgeIdToDuplicatedEdge = new HashMap<Integer, Edge>();
        Set<Edge> edgesBoardOfOriginalThinSurface = this.computeEdgeBoard(meshMask);
        this.fillMappingEdge(originalEdgeIdToDuplicatedEdge, edgesBoardOfOriginalThinSurface);
        Set<Vertex> verticesBoardOfOriginalThinSurface = this.computeVertexBoard(edgesBoardOfOriginalThinSurface);
        for (Vertex currentVertexBoard : verticesBoardOfOriginalThinSurface) {
            Vertex vertexOnDuplicatedThinSurface = this.originalVertexIdToClone.get(currentVertexBoard.getId());
            List<Face> facesOnVertexOfOriginalThinSurface = this.mesh.getFacesOnVertex(currentVertexBoard.getId());
            List<Face> facesOnVertexOfDuplicatedThinSurface = this.mesh.getFacesOnVertex(vertexOnDuplicatedThinSurface.getId());
            for (Face faceOnOriginalThinSurface : facesOnVertexOfOriginalThinSurface) {
                for (Face faceOnDuplicatedThinSurface : facesOnVertexOfDuplicatedThinSurface) {
                    Edge[] edgesInContactWithDuplicatedThinSurface;
                    Edge[] edgesInContactWithOriginalThinSurface;
                    int commonVertexCount = this.computeCommonVertexCount(faceOnOriginalThinSurface, faceOnDuplicatedThinSurface);
                    if (commonVertexCount == 2) {
                        originalFaceIdToDuplicatedFace.put(faceOnOriginalThinSurface.getId(), faceOnDuplicatedThinSurface);
                        edgesInContactWithOriginalThinSurface = faceOnOriginalThinSurface.getEdges();
                        edgesInContactWithDuplicatedThinSurface = faceOnDuplicatedThinSurface.getEdges();
                        for (Edge edgeInContactWithOriginalThinSurface : edgesInContactWithOriginalThinSurface) {
                            for (Edge edgeInContactWithDuplicatedThinSurface : edgesInContactWithDuplicatedThinSurface) {
                                commonVertexCount = this.computeCommonVertexCount(edgeInContactWithOriginalThinSurface, edgeInContactWithDuplicatedThinSurface);
                                if (commonVertexCount != 1) continue;
                                this.computeEdgesFrontOf(originalEdgeIdToDuplicatedEdge, edgeInContactWithOriginalThinSurface, edgeInContactWithDuplicatedThinSurface);
                            }
                        }
                        continue;
                    }
                    if (commonVertexCount != 1 || (commonVertexCount = this.computeVertexOnOriginalThinSurfaceCount(faceOnOriginalThinSurface)) != 2 || (commonVertexCount = this.computeVertexOnDuplicatedThinSurfaceCount(faceOnDuplicatedThinSurface)) != 2) continue;
                    commonVertexCount = 0;
                    Vertex[] verticesOnFaceOnOriginalThinSurface = faceOnOriginalThinSurface.getVertices();
                    Vertex[] verticesOnFaceOnDuplicatedThinSurface = faceOnDuplicatedThinSurface.getVertices();
                    for (Vertex vertex : verticesOnFaceOnOriginalThinSurface) {
                        Vertex vertexDuplicated = this.originalVertexIdToClone.get(vertex.getId());
                        if (vertexDuplicated == null || !vertexDuplicated.equals(verticesOnFaceOnDuplicatedThinSurface[0]) && !vertexDuplicated.equals(verticesOnFaceOnDuplicatedThinSurface[1]) && !vertexDuplicated.equals(verticesOnFaceOnDuplicatedThinSurface[2])) continue;
                        ++commonVertexCount;
                    }
                    if (commonVertexCount != 2) continue;
                    originalFaceIdToDuplicatedFace.put(faceOnOriginalThinSurface.getId(), faceOnDuplicatedThinSurface);
                    edgesInContactWithOriginalThinSurface = faceOnOriginalThinSurface.getEdges();
                    edgesInContactWithDuplicatedThinSurface = faceOnDuplicatedThinSurface.getEdges();
                    for (MeshElement meshElement : edgesInContactWithOriginalThinSurface) {
                        for (Edge edgeInContactWithDuplicatedThinSurface : edgesInContactWithDuplicatedThinSurface) {
                            this.computeEdgesFrontOf(originalEdgeIdToDuplicatedEdge, (Edge)meshElement, edgeInContactWithDuplicatedThinSurface);
                        }
                    }
                }
            }
        }
        OutputMeshSplitting answer = new OutputMeshSplitting(originalFaceIdToDuplicatedFace, originalEdgeIdToDuplicatedEdge, this.mesh, this.originalEdgeIdToClone, this.originalVertexIdToClone, this.originalFaceIdToClone, meshMask);
        Set faceEntrySet = originalFaceIdToDuplicatedFace.entrySet();
        for (Map.Entry entry : faceEntrySet) {
            this.originalFaceIdToClone.put((Integer)entry.getKey(), (Face)entry.getValue());
        }
        Set edgeEntrySet = originalEdgeIdToDuplicatedEdge.entrySet();
        for (Map.Entry entry : edgeEntrySet) {
            this.originalEdgeIdToClone.put((Integer)entry.getKey(), (Edge)entry.getValue());
        }
        return answer;
    }

    private void fillMappingEdge(Map<Integer, Edge> originalEdgeIdToDuplicatedEdge, Set<Edge> edgesBoardOfOriginalThinSurface) {
        for (Edge edgeBoardOfOriginalThinSurface : edgesBoardOfOriginalThinSurface) {
            Edge edgeBoardOfDuplicatedThinSurface = this.originalEdgeIdToClone.get(edgeBoardOfOriginalThinSurface.getId());
            originalEdgeIdToDuplicatedEdge.put(edgeBoardOfOriginalThinSurface.getId(), edgeBoardOfDuplicatedThinSurface);
        }
    }

    private void computeEdgesFrontOf(Map<Integer, Edge> originalEdgeIdToDuplicatedEdge, Edge edgeInContactWithOriginalThinSurface, Edge edgeInContactWithDuplicatedThinSurface) {
        Vertex cloneVertexOnOriginalThinSurface;
        Vertex vertex0OnOriginalThinSurface = edgeInContactWithOriginalThinSurface.getVertexAt(0);
        Vertex vertex1OnOriginalThinSurface = edgeInContactWithOriginalThinSurface.getVertexAt(1);
        Vertex vertex0OnDuplicatedThinSurface = edgeInContactWithDuplicatedThinSurface.getVertexAt(0);
        Vertex vertex1OnDuplicatedThinSurface = edgeInContactWithDuplicatedThinSurface.getVertexAt(1);
        if (vertex0OnOriginalThinSurface.equals(vertex0OnDuplicatedThinSurface)) {
            Vertex cloneVertexOnOriginalThinSurface2 = this.originalVertexIdToClone.get(vertex1OnOriginalThinSurface.getId());
            if (vertex1OnDuplicatedThinSurface.equals(cloneVertexOnOriginalThinSurface2)) {
                originalEdgeIdToDuplicatedEdge.put(edgeInContactWithOriginalThinSurface.getId(), edgeInContactWithDuplicatedThinSurface);
            }
        } else if (vertex0OnOriginalThinSurface.equals(vertex1OnDuplicatedThinSurface)) {
            Vertex cloneVertexOnOriginalThinSurface3 = this.originalVertexIdToClone.get(vertex1OnOriginalThinSurface.getId());
            if (vertex0OnDuplicatedThinSurface.equals(cloneVertexOnOriginalThinSurface3)) {
                originalEdgeIdToDuplicatedEdge.put(edgeInContactWithOriginalThinSurface.getId(), edgeInContactWithDuplicatedThinSurface);
            }
        } else if (vertex1OnOriginalThinSurface.equals(vertex0OnDuplicatedThinSurface)) {
            Vertex cloneVertexOnOriginalThinSurface4 = this.originalVertexIdToClone.get(vertex0OnOriginalThinSurface.getId());
            if (vertex1OnDuplicatedThinSurface.equals(cloneVertexOnOriginalThinSurface4)) {
                originalEdgeIdToDuplicatedEdge.put(edgeInContactWithOriginalThinSurface.getId(), edgeInContactWithDuplicatedThinSurface);
            }
        } else if (vertex1OnOriginalThinSurface.equals(vertex1OnDuplicatedThinSurface) && vertex0OnDuplicatedThinSurface.equals(cloneVertexOnOriginalThinSurface = this.originalVertexIdToClone.get(vertex0OnOriginalThinSurface.getId()))) {
            originalEdgeIdToDuplicatedEdge.put(edgeInContactWithOriginalThinSurface.getId(), edgeInContactWithDuplicatedThinSurface);
        }
    }

    private Set<Vertex> computeVertexBoard(Set<Edge> edgesBoardOfOriginalThinSurface) {
        TreeSet<Vertex> answer = new TreeSet<Vertex>();
        for (Edge edgeBoardOfOriginalThinSurface : edgesBoardOfOriginalThinSurface) {
            Vertex[] verticesOnBoardOfOriginalThinSurface;
            for (Vertex vertexOnBoardOfOriginalThinSurface : verticesOnBoardOfOriginalThinSurface = edgeBoardOfOriginalThinSurface.getVertices()) {
                answer.add(vertexOnBoardOfOriginalThinSurface);
            }
        }
        return answer;
    }

    private int computeVertexOnOriginalThinSurfaceCount(Face faceOnOriginalThinSurface) {
        Vertex[] verticesOnOriginalThinSurface;
        int commonVertexCount = 0;
        for (Vertex vertexOnOriginalThinSurface : verticesOnOriginalThinSurface = faceOnOriginalThinSurface.getVertices()) {
            Vertex vertexOnDuplicatedThinSurface = this.originalVertexIdToClone.get(vertexOnOriginalThinSurface.getId());
            if (vertexOnDuplicatedThinSurface == null) continue;
            ++commonVertexCount;
        }
        return commonVertexCount;
    }

    private int computeVertexOnDuplicatedThinSurfaceCount(Face faceOnDuplicatedThinSurface) {
        Vertex[] verticesOnDuplicatedThinSurface;
        int commonVertexCount = 0;
        for (Vertex vertexOnDupplicatedThinSurface : verticesOnDuplicatedThinSurface = faceOnDuplicatedThinSurface.getVertices()) {
            Boolean isVertexDuplicated = this.originalVertexIdToClone.containsValue(vertexOnDupplicatedThinSurface);
            if (!isVertexDuplicated.booleanValue()) continue;
            ++commonVertexCount;
        }
        return commonVertexCount;
    }

    private int computeCommonVertexCount(Edge meshElement1, Edge meshElement2) {
        int answer = 0;
        Vertex[] verticesOnMeshElement1 = meshElement1.getVertices();
        Vertex[] verticesOnMeshElement2 = meshElement2.getVertices();
        for (Vertex vertexOnMeshElement1 : verticesOnMeshElement1) {
            for (Vertex vertexOnMeshElement2 : verticesOnMeshElement2) {
                if (!vertexOnMeshElement2.equals(vertexOnMeshElement1)) continue;
                ++answer;
            }
        }
        return answer;
    }

    private Set<Edge> computeEdgeBoard(MeshMask<Face> meshMask) {
        TreeSet<Edge> answer = new TreeSet<Edge>();
        TreeSet<Edge> temporarySet = new TreeSet<Edge>();
        Iterator<Face> faceIterator = meshMask.getMeshElementIterator();
        while (faceIterator.hasNext()) {
            Edge[] edgesOnOriginalThinSurface;
            Face currentFaceOnOriginalThinSurface = faceIterator.next();
            for (Edge currentEdgeOnOriginalThinSurface : edgesOnOriginalThinSurface = currentFaceOnOriginalThinSurface.getEdges()) {
                if (temporarySet.contains(currentEdgeOnOriginalThinSurface)) {
                    answer.remove(currentEdgeOnOriginalThinSurface);
                    continue;
                }
                temporarySet.add(currentEdgeOnOriginalThinSurface);
                answer.add(currentEdgeOnOriginalThinSurface);
            }
        }
        return answer;
    }

    private void computeNormalOfVertices(MeshMask<Face> meshMask) {
        Set<Integer> vertexIdsOfThinPlate = this.originalVertexIdToClone.keySet();
        for (Integer vertexIdOfThinPlate : vertexIdsOfThinPlate) {
            List<Face> facesOnVertex = this.mesh.getFacesOnVertex(vertexIdOfThinPlate);
            ArrayList<Integer> faceIdsNearVertexOnThinPlate = new ArrayList<Integer>();
            for (Face faceOnVertex : facesOnVertex) {
                boolean isFaceOnThinPlate = false;
                List<MeshMask<Face>> meshMasks = this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(faceOnVertex.getId());
                if (meshMasks != null) {
                    for (MeshMask<Face> currentMeshMask : meshMasks) {
                        if (meshMask.getId() != currentMeshMask.getId()) continue;
                        isFaceOnThinPlate = true;
                    }
                }
                if (!isFaceOnThinPlate) continue;
                faceIdsNearVertexOnThinPlate.add(faceOnVertex.getId());
            }
            double[] normalOfVertex = new double[3];
            for (Integer faceIdNearVertexOnThinPlate : faceIdsNearVertexOnThinPlate) {
                double[] normalOfTriangle = this.triangleNormalOfThinPlate.get(faceIdNearVertexOnThinPlate);
                normalOfVertex[0] = normalOfVertex[0] + normalOfTriangle[0];
                normalOfVertex[1] = normalOfVertex[1] + normalOfTriangle[1];
                normalOfVertex[2] = normalOfVertex[2] + normalOfTriangle[2];
            }
            this.vertexNormalOfThinPlate.put(vertexIdOfThinPlate, normalOfVertex);
        }
    }

    private void computeConnectivityOfPolyhedraWithAtLeast1VertexOnThinPlate(MeshMask<Face> meshMask) {
        Set<Integer> vertexIdsOfThinPlate = this.originalVertexIdToClone.keySet();
        for (Integer vertexIdOfThinPlate : vertexIdsOfThinPlate) {
            List<Polyhedron> polyhedraOnVertex = this.mesh.getPolyhedraOnVertex(vertexIdOfThinPlate);
            Vertex vertexOfThinPlate = this.mesh.getVertexById(vertexIdOfThinPlate);
            for (Polyhedron polyhedronOnVertex : polyhedraOnVertex) {
                boolean isValidPolyhedron = true;
                Face[] facesOnPolyhedron = polyhedronOnVertex.getFaces();
                for (int faceIndex = 0; faceIndex < facesOnPolyhedron.length && isValidPolyhedron; ++faceIndex) {
                    Face face = facesOnPolyhedron[faceIndex];
                    int faceId = face.getId();
                    Face faceById = this.mesh.getFaceById(faceId);
                    isValidPolyhedron = isValidPolyhedron && !this.confirmMeshMaskId(faceById, meshMask.getId());
                }
                if (!isValidPolyhedron) continue;
                double[] vector1 = new double[3];
                Vertex[] verticesOnPolyhedron = polyhedronOnVertex.getVertices();
                Point[] cellNodes = new Point[4];
                for (int vertexIndex = 0; vertexIndex < verticesOnPolyhedron.length; ++vertexIndex) {
                    cellNodes[vertexIndex] = verticesOnPolyhedron[vertexIndex].getPoint();
                }
                double[] computeIsoBaryCenter = Barycentre.computeIsoBaryCenter(cellNodes);
                vector1[0] = computeIsoBaryCenter[0] - vertexOfThinPlate.getPoint().getCoord()[0];
                vector1[1] = computeIsoBaryCenter[1] - vertexOfThinPlate.getPoint().getCoord()[1];
                vector1[2] = computeIsoBaryCenter[2] - vertexOfThinPlate.getPoint().getCoord()[2];
                double[] normalOfVertex = this.vertexNormalOfThinPlate.get(vertexOfThinPlate.getId());
                double scalarProduct = VectorUtilDouble.scalarProduct(vector1, normalOfVertex);
                if (!(scalarProduct < 0.0)) continue;
                Vertex vertexDuplicated = this.originalVertexIdToClone.get(vertexIdOfThinPlate);
                int vertexPosition = polyhedronOnVertex.getVertexPosition(vertexIdOfThinPlate);
                verticesOnPolyhedron[vertexPosition] = vertexDuplicated;
            }
        }
    }

    private void computeConnectivityOfPolyhedraWithAFaceOnThinPlate(MeshMask<Face> meshMask) {
        Iterator<Face> faceIterator = meshMask.getMeshElementIterator();
        while (faceIterator.hasNext()) {
            Face face = faceIterator.next();
            List<Polyhedron> polyhedraOnFace = this.mesh.getPolyhedraOnFace(face.getId());
            ArrayList<Polyhedron> copyOfPolyhedraOnFace = new ArrayList<Polyhedron>(polyhedraOnFace);
            for (Polyhedron polyhedronTmp : copyOfPolyhedraOnFace) {
                int index = polyhedraOnFace.indexOf(polyhedronTmp);
                Polyhedron polyhedron = polyhedraOnFace.get(index);
                Vertex vertexOutOfThinPlate = this.computeVertexOutOfThinPlateofPolyhedron(face, polyhedron);
                double[] vector1 = new double[3];
                Vertex[] verticesOnPolyhedron = polyhedron.getVertices();
                Point[] cellNodes = new Point[4];
                for (int vertexIndex = 0; vertexIndex < verticesOnPolyhedron.length; ++vertexIndex) {
                    cellNodes[vertexIndex] = verticesOnPolyhedron[vertexIndex].getPoint();
                }
                double[] computeIsoBaryCenter = Barycentre.computeIsoBaryCenter(cellNodes);
                vector1[0] = vertexOutOfThinPlate.getPoint().getCoord()[0] - computeIsoBaryCenter[0];
                vector1[1] = vertexOutOfThinPlate.getPoint().getCoord()[1] - computeIsoBaryCenter[1];
                vector1[2] = vertexOutOfThinPlate.getPoint().getCoord()[2] - computeIsoBaryCenter[2];
                double[] normalOfFace = this.triangleNormalOfThinPlate.get(face.getId());
                double scalarProduct = VectorUtilDouble.scalarProduct(vector1, normalOfFace);
                if (!(scalarProduct < 0.0)) continue;
                this.attachMeshElementToTheGoodVertex(polyhedron, vertexOutOfThinPlate);
            }
        }
    }

    private Vertex computeVertexOutOfThinPlateofPolyhedron(Face face, Polyhedron polyhedron) {
        Face[] facesOfPolyhedron;
        for (Face faceOfPolyedron : facesOfPolyhedron = polyhedron.getFaces()) {
            if (faceOfPolyedron.equals(face)) continue;
            Vertex[] verticesOfFaceOfPolyhdron = faceOfPolyedron.getVertices();
            Vertex[] verticesOfFaceMeshMask = face.getVertices();
            for (Vertex vertexOfFaceOfPolyhdron : verticesOfFaceOfPolyhdron) {
                if (vertexOfFaceOfPolyhdron.equals(verticesOfFaceMeshMask[0]) || vertexOfFaceOfPolyhdron.equals(verticesOfFaceMeshMask[1]) || vertexOfFaceOfPolyhdron.equals(verticesOfFaceMeshMask[2])) continue;
                return vertexOfFaceOfPolyhdron;
            }
        }
        return null;
    }

    private void attachMeshElementToTheGoodVertex(Polyhedron polyhedron, Vertex vertexOutOfThinPlate) {
        for (int index = 0; index < polyhedron.getNbVertices(); ++index) {
            Vertex vertexInsideDuplicatedFace;
            if (polyhedron.getVertices()[index].equals(vertexOutOfThinPlate)) continue;
            polyhedron.getVertices()[index] = vertexInsideDuplicatedFace = this.originalVertexIdToClone.get(polyhedron.getVertices()[index].getId());
        }
    }

    private void computeNormalOfFace(MeshMask<Face> meshMask, Map<Integer, double[]> triangleNormal) {
        Vertex finishedVertexOfSecondVector;
        Iterator<Face> faceIterator = meshMask.getMeshElementIterator();
        if (!faceIterator.hasNext()) {
            throw new IllegalArgumentException("The input face mesh mask is empty, its id is : " + meshMask.getId());
        }
        Face currentFace = faceIterator.next();
        Edge[] edges = currentFace.getEdges();
        Edge firstEdge = edges[0];
        Edge secondEdge = edges[1];
        Edge thirdEdge = edges[2];
        double[] firstVector = new double[3];
        double[] secondVector = new double[3];
        Vertex firstVertexInsideFirstEdge = firstEdge.getVertexAt(0);
        Vertex secondVertexInsideFirstEdge = firstEdge.getVertexAt(1);
        if (secondEdge.getVertexAt(0).equals(secondVertexInsideFirstEdge)) {
            finishedVertexOfSecondVector = secondEdge.getVertexAt(1);
        } else if (thirdEdge.getVertexAt(0).equals(secondVertexInsideFirstEdge)) {
            finishedVertexOfSecondVector = thirdEdge.getVertexAt(1);
        } else {
            throw new UnsupportedOperationException("We consider splitting is only on triangle which has the following configuration :\nEach edge of triangle has 2 local vertices called vertex0 and vertex1. Their order is the same in all edges of the same triangle.");
        }
        double[] coordOfSecondVertexInFirstEdge = secondVertexInsideFirstEdge.getPoint().getCoord();
        double[] coordOfFirstVertexInsideFirstEdge = firstVertexInsideFirstEdge.getPoint().getCoord();
        double[] coordOfFinishedVertexOfSecondVector = finishedVertexOfSecondVector.getPoint().getCoord();
        firstVector[0] = coordOfSecondVertexInFirstEdge[0] - coordOfFirstVertexInsideFirstEdge[0];
        firstVector[1] = coordOfSecondVertexInFirstEdge[1] - coordOfFirstVertexInsideFirstEdge[1];
        firstVector[2] = coordOfSecondVertexInFirstEdge[2] - coordOfFirstVertexInsideFirstEdge[2];
        secondVector[0] = coordOfFinishedVertexOfSecondVector[0] - coordOfSecondVertexInFirstEdge[0];
        secondVector[1] = coordOfFinishedVertexOfSecondVector[1] - coordOfSecondVertexInFirstEdge[1];
        secondVector[2] = coordOfFinishedVertexOfSecondVector[2] - coordOfSecondVertexInFirstEdge[2];
        double[] computeVectorProduct = VectorUtilDouble.dotProduct(firstVector, secondVector);
        triangleNormal.put(currentFace.getId(), computeVectorProduct);
        List<Face> facesOnFirstEdge = this.mesh.getFacesOnEdge(firstEdge.getId());
        boolean fromVertex0ToVertex1 = true;
        for (Face face : facesOnFirstEdge) {
            this.computeRecursivlyNormal(firstEdge, face, currentFace, meshMask.getId(), triangleNormal, true);
        }
        List<Face> facesOnAnotherEdge1 = this.mesh.getFacesOnEdge(secondEdge.getId());
        for (Face face2 : facesOnAnotherEdge1) {
            this.computeRecursivlyNormal(secondEdge, face2, currentFace, meshMask.getId(), triangleNormal, true);
        }
        List<Face> facesOnAnotherEdge2 = this.mesh.getFacesOnEdge(thirdEdge.getId());
        for (Face face3 : facesOnAnotherEdge2) {
            this.computeRecursivlyNormal(thirdEdge, face3, currentFace, meshMask.getId(), triangleNormal, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeRecursivlyNormal(Edge firstEdge, Face currentFace, Face previousFace, int meshMaskId, Map<Integer, double[]> triangleNormal, boolean fromVertex0ToVertex1) {
        boolean fromVertex0ToVertex1InNewEdge;
        Vertex vertex0OfEdgeNextCommonEdge;
        Vertex vertex1OfEdgeNextCommonEdge;
        boolean confirmMeshMaskId = this.confirmMeshMaskId(currentFace, meshMaskId);
        if (!confirmMeshMaskId) {
            return;
        }
        if (triangleNormal.containsKey(currentFace.getId())) {
            return;
        }
        int currentEdgeId = firstEdge.getId();
        int edgePositionInCurrentFace = currentFace.getEdgePosition(currentEdgeId);
        Edge commonEdgeInCurrentFace = currentFace.getEdgeAt(edgePositionInCurrentFace);
        Vertex vertex0OfCommonEdgeInCurrentFace = commonEdgeInCurrentFace.getVertexAt(0);
        Vertex vertex1OfCommonEdgeInCurrentFace = commonEdgeInCurrentFace.getVertexAt(1);
        int edgePositionInPreviousFace = previousFace.getEdgePosition(currentEdgeId);
        Edge commonEdgeInPreviousFace = previousFace.getEdgeAt(edgePositionInPreviousFace);
        Vertex vertex0OfCommonEdgeInPreviousFace = commonEdgeInPreviousFace.getVertexAt(0);
        Vertex vertex1OfCommonEdgeInPreviousFace = commonEdgeInPreviousFace.getVertexAt(1);
        double[] secondVector = new double[3];
        double[] firstVector = new double[3];
        int edgePositionTmp = (edgePositionInCurrentFace + 1) % currentFace.getNbEdges();
        Edge edge2InCurrentFace = currentFace.getEdgeAt(edgePositionTmp);
        edgePositionTmp = (edgePositionTmp + 1) % currentFace.getNbEdges();
        Edge edge3InCurrentFace = currentFace.getEdgeAt(edgePositionTmp);
        if (fromVertex0ToVertex1) {
            if (vertex0OfCommonEdgeInCurrentFace.equals(vertex0OfCommonEdgeInPreviousFace)) {
                if (edge2InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) {
                    vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
                } else {
                    if (!edge3InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                    vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
                }
                firstVector[0] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                firstVector[1] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                firstVector[2] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                secondVector[0] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                secondVector[1] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                secondVector[2] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                fromVertex0ToVertex1InNewEdge = false;
            } else {
                if (!vertex0OfCommonEdgeInCurrentFace.equals(vertex1OfCommonEdgeInPreviousFace)) throw new UnsupportedOperationException();
                if (edge2InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) {
                    vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
                } else {
                    if (!edge3InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                    vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
                }
                firstVector[0] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                firstVector[1] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                firstVector[2] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                secondVector[0] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                secondVector[1] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                secondVector[2] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                fromVertex0ToVertex1InNewEdge = true;
            }
        } else if (vertex0OfCommonEdgeInCurrentFace.equals(vertex0OfCommonEdgeInPreviousFace)) {
            if (edge2InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) {
                vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
            } else {
                if (!edge3InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
            }
            firstVector[0] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            firstVector[1] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            firstVector[2] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            secondVector[0] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            secondVector[1] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            secondVector[2] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            fromVertex0ToVertex1InNewEdge = true;
        } else {
            if (!vertex0OfCommonEdgeInCurrentFace.equals(vertex1OfCommonEdgeInPreviousFace)) throw new UnsupportedOperationException();
            if (edge2InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) {
                vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
            } else {
                if (!edge3InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
            }
            firstVector[0] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            firstVector[1] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            firstVector[2] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            secondVector[0] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            secondVector[1] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            secondVector[2] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            fromVertex0ToVertex1InNewEdge = false;
        }
        double[] computeVectorProduct = VectorUtilDouble.dotProduct(firstVector, secondVector);
        triangleNormal.put(currentFace.getId(), computeVectorProduct);
        for (Face face : this.mesh.getFacesOnEdge(edge2InCurrentFace.getId())) {
            this.computeRecursivlyNormal(edge2InCurrentFace, face, currentFace, meshMaskId, triangleNormal, fromVertex0ToVertex1InNewEdge);
        }
        for (Face face : this.mesh.getFacesOnEdge(edge3InCurrentFace.getId())) {
            this.computeRecursivlyNormal(edge3InCurrentFace, face, currentFace, meshMaskId, triangleNormal, fromVertex0ToVertex1InNewEdge);
        }
    }

    private boolean confirmMeshMaskId(Face currentFace, int meshMaskId) {
        List<MeshMask<Face>> meshMasks = this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(currentFace.getId());
        if (meshMasks != null) {
            for (MeshMask<Face> meshMaskIdTmp : meshMasks) {
                if (meshMaskIdTmp.getId() != meshMaskId) continue;
                return true;
            }
        }
        return false;
    }

    private void duplicateMeshElements(MeshMask<Face> meshMask, double gapXTranslation, double gapYTranslation, double gapZTranslation, MeshMask<Face> newFaceMeshMask) {
        Iterator<Face> faceIterator = meshMask.getMeshElementIterator();
        while (faceIterator.hasNext()) {
            Edge[] edgesOnThinPlate;
            Face faceOnThinPlate = faceIterator.next();
            for (Edge edgeOnThinPlate : edgesOnThinPlate = faceOnThinPlate.getEdges()) {
                Vertex[] verticesOnThinPlate;
                int edgeIdOnThinPlate = edgeOnThinPlate.getId();
                if (this.originalEdgeIdToClone.get(edgeIdOnThinPlate) != null) continue;
                for (Vertex vertexOnThinPlate : verticesOnThinPlate = edgeOnThinPlate.getVertices()) {
                    int vertexIdOnThinplate = vertexOnThinPlate.getId();
                    if (this.originalVertexIdToClone.get(vertexIdOnThinplate) != null) continue;
                    double[] coord = vertexOnThinPlate.getPoint().getCoord();
                    double[] coordCopy = new double[]{coord[0] - gapXTranslation, coord[1] - gapYTranslation, coord[2] - gapZTranslation};
                    Node vertexCopy = new Node(this.mesh, coordCopy);
                    this.mesh.addMeshElementAndUpdateConnectivity(vertexCopy);
                    this.originalVertexIdToClone.put(vertexIdOnThinplate, vertexCopy);
                }
                Vertex startVertex = verticesOnThinPlate[0];
                Vertex endVertex = verticesOnThinPlate[1];
                Vertex startVertexDuplicated = this.originalVertexIdToClone.get(startVertex.getId());
                Vertex endVertexDuplicated = this.originalVertexIdToClone.get(endVertex.getId());
                Segment segment = new Segment(this.mesh, startVertexDuplicated, endVertexDuplicated);
                this.mesh.addMeshElementAndUpdateConnectivity(segment);
                this.originalEdgeIdToClone.put(edgeIdOnThinPlate, segment);
            }
            Vertex firstVertexOnOriginalFace = faceOnThinPlate.getVertexAt(0);
            Vertex secondVertexOnOriginalFace = faceOnThinPlate.getVertexAt(1);
            Vertex thirdVertexOnOriginalFace = faceOnThinPlate.getVertexAt(2);
            Vertex firstVertexOnDuplicatedFace = this.originalVertexIdToClone.get(firstVertexOnOriginalFace.getId());
            Vertex secondVertexOnDuplicatedFace = this.originalVertexIdToClone.get(secondVertexOnOriginalFace.getId());
            Vertex thirdVertexOnDuplicatedFace = this.originalVertexIdToClone.get(thirdVertexOnOriginalFace.getId());
            Triangle triangle = new Triangle(this.mesh, firstVertexOnDuplicatedFace, secondVertexOnDuplicatedFace, thirdVertexOnDuplicatedFace);
            int newFaceId = this.mesh.addMeshElementAndUpdateConnectivity(triangle);
            this.originalFaceIdToClone.put(faceOnThinPlate.getId(), triangle);
            newFaceMeshMask.addMeshElementId(newFaceId);
            this.mesh.getDataFieldManager().addMeshMaskToFaceId(newFaceMeshMask, newFaceId);
        }
    }

    public Map<Integer, double[]> getTriangleNormalOfFirstMeshMak() {
        return this.triangleNormalOfThinPlate;
    }

    public Map<Integer, Edge> getOriginalEdgeIdToClone() {
        return this.originalEdgeIdToClone;
    }

    public Map<Integer, Vertex> getOriginalVertexIdToClone() {
        return this.originalVertexIdToClone;
    }

    public Map<Integer, Face> getOriginalFaceIdToClone() {
        return this.originalFaceIdToClone;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    protected Map<Integer, double[]> getVertexNormalOfThinPlate() {
        return this.vertexNormalOfThinPlate;
    }
}

