/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.renderer.vtk;

public class VtkContextLoader {
    private int verboseLevel = 0;
    public static final String errorMessage = "VTK native context loading error. \n \nImpossible to load the native layer (JNI) of the VTK's libraries! \nWe could not find them in the LD_LIBRARY_PATH for Linux/Unix systems, \nin DYLD_LIBRARY_PATH for Apple MacOSX systems or in the PATH for \n MS/Windows systems; or we could nt able to load the native layer. \nPlease check this. \nThe CLASSPATH should include all jars related to VTK and the JNI \n layers (e.g vtk.jar). Theses paths should be defined/set BEFORE \nlaunching the JVM.\nSee the Cassandra's or the Keridwen's projects pages for further \ninformation, supports and/or advices: \n http://www.artenum.com/cassandra\n http://www.artenum.com/keridwen";

    public VtkContextLoader() {
    }

    public VtkContextLoader(int verboseLevel) {
        this.verboseLevel = verboseLevel;
    }

    public boolean load() {
        try {
            System.out.print("Try to load the VTK native layer... ");
            System.loadLibrary("vtkCommonJava");
            System.loadLibrary("vtkRenderingJava");
            System.loadLibrary("vtkImagingJava");
            System.loadLibrary("vtkIOJava");
            System.loadLibrary("vtkFilteringJava");
            System.loadLibrary("vtkGraphicsJava");
            System.loadLibrary("vtkHybridJava");
            try {
                System.loadLibrary("vtkParallelJava");
            }
            catch (Throwable errorPara) {
                System.out.println("No vtkParallelJava present... not critical");
            }
            System.out.println("VTK context loaded.");
            return true;
        }
        catch (Throwable e) {
            if (this.verboseLevel > 0) {
                System.out.println("Error in loading VTK layer, no VTK found in the LD_LIBRARY_PATH.");
                System.out.println("java.library.path= " + System.getProperty("java.library.path"));
            }
            if (this.verboseLevel > 1) {
                System.out.println(e.getMessage());
            }
            if (this.verboseLevel > 2) {
                System.out.println(errorMessage);
            }
            return false;
        }
    }
}

