/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cellcenter;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.cellcenter.CellCenterControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkCellCenters;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class CellCenterPlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Cutting plane";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private CellCenterControlUI controlUI;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkCellCenters cellCenter;
    private vtkPolyDataMapper centerMapper;
    private vtkActor centerActor;
    private Filter filterImpl;
    private CassandraObject actor;
    private CassandraObject mapper;
    private CassandraObject dataset;
    private CassandraObject filter;

    public CellCenterPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new CellCenterControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Cell Center filter menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellCenterPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellCenterPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.cellCenter = new vtkCellCenters();
        this.centerMapper = new vtkPolyDataMapper();
        this.centerMapper.SetInput(this.cellCenter.GetOutput());
        this.centerActor = new vtkActor();
        this.centerActor.SetMapper((vtkMapper)this.centerMapper);
        this.lookupTable = new vtkLookupTable();
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.centerMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.scalarBar = new vtkScalarBarActor();
        this.scalarBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.actor = pipelineManager.addActor((Object)this.centerActor, "Cell Centers");
        this.mapper = pipelineManager.addMapper((Object)this.centerMapper, "Cell Centers");
        this.dataset = pipelineManager.addDataSet((Object)this.cellCenter.GetOutput(), "Cell Centers");
        this.filter = pipelineManager.addFilter(this.filterImpl, "Cell Centers");
        pipelineManager.addLookupTable(this.lookupTable, "Cell Centers");
        pipelineManager.setActorVisible(pipelineManager.addScalarBar(this.scalarBar, "Cell Centers"), true);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateCellCenter(int vertexCellsFlag, vtkDataSet vtkDataSet2) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.actor.setValide(true);
        this.cellCenter.SetInput((vtkDataObject)vtkDataSet2);
        this.cellCenter.SetVertexCells(vertexCellsFlag);
        if (!(vtkDataSet2.GetPointData().GetScalars() == null && vtkDataSet2.GetCellData().GetScalars() == null || this.lastDataSet != null && this.lastDataSet.equals(vtkDataSet2) || !this.centerMapper.GetLookupTable().equals(this.lookupTable))) {
            this.centerMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.pipelineManager.hideInputActor(this.actor, vtkDataSet2);
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.cellCenter.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.filter);
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

