/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole;

import com.artenum.jyconsole.JyConsole;
import java.util.ArrayList;

public class HistoryManager {
    private JyConsole console;
    private ArrayList history;
    private int historyIndex;
    private boolean inHistory;

    public HistoryManager(JyConsole jyConsole) {
        this.console = jyConsole;
        this.history = new ArrayList();
    }

    public void addCommandInHistory(String string) {
        this.stopHistoryNavigation();
        this.history.remove(string);
        this.history.add(string);
    }

    public void showPreviousCommand() {
        if (!this.inHistory) {
            this.startHistoryNavigation();
        }
        --this.historyIndex;
        if (this.isInRange()) {
            this.console.getInteractiveCommandLine().reset();
            this.console.getInteractiveCommandLine().append((String)this.history.get(this.historyIndex));
        } else {
            ++this.historyIndex;
        }
    }

    public void showNextCommand() {
        if (!this.inHistory) {
            return;
        }
        ++this.historyIndex;
        if (this.isInRange()) {
            this.console.getInteractiveCommandLine().reset();
            this.console.getInteractiveCommandLine().append((String)this.history.get(this.historyIndex));
        } else {
            --this.historyIndex;
        }
    }

    public void startHistoryNavigation() {
        this.inHistory = true;
        this.history.add(this.console.getInteractiveCommandLine().getCmdLine());
        this.historyIndex = this.history.size() - 1;
    }

    public void stopHistoryNavigation() {
        if (!this.inHistory) {
            return;
        }
        this.inHistory = false;
        if (this.history.size() > 0 && ((String)this.history.get(this.history.size() - 1)).trim().length() == 0) {
            this.history.remove(this.history.size() - 1);
        }
    }

    public boolean isInHistory() {
        return this.inHistory;
    }

    public boolean isInRange() {
        return this.historyIndex >= 0 && this.historyIndex < this.history.size();
    }
}

