/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.listener;

import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.GraphModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;

public class GroupDragListener
implements MouseMotionListener,
MouseListener {
    protected GraphModel model;
    protected int x;
    protected int y;
    protected int dx;
    protected int dy;
    protected boolean dragging = false;
    protected boolean enableGroupDrag;
    protected Component parentComponent;

    public GroupDragListener(GraphModel graphModel, Component component) {
        this.model = graphModel;
        this.parentComponent = component;
    }

    public void setGroupDragEnable(boolean bl) {
        this.enableGroupDrag = bl;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.enableGroupDrag) {
            return;
        }
        if (!this.dragging) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
        }
        this.dragging = true;
        this.dx = mouseEvent.getX() - this.x;
        this.dy = mouseEvent.getY() - this.y;
        Iterator iterator = this.model.getCellList().iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            if (!cell.isSelected()) continue;
            Component component = cell.getUI();
            component.setBounds(component.getBounds().x + this.dx, component.getBounds().y + this.dy, component.getWidth(), component.getHeight());
            Point point = component.getLocation();
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            component.setLocation(point);
        }
        this.parentComponent.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

