/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.listener;

import com.artenum.graph.interfaces.Cell;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DragListener
implements MouseMotionListener,
MouseListener {
    protected Component ui;
    protected Cell cell;
    protected int x;
    protected int y;
    protected int dx;
    protected int dy;
    protected boolean dragging = false;

    public DragListener(Cell cell, Component component, Component component2, boolean bl) {
        this.cell = cell;
        this.ui = component;
        if (bl) {
            component2.addMouseMotionListener(this);
            component2.addMouseListener(this);
        }
    }

    public DragListener(Cell cell, Component component, Component component2) {
        this(cell, component, component2, true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.cell.isSelected()) {
            return;
        }
        if (!this.dragging) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
        }
        this.dragging = true;
        this.dx = mouseEvent.getX() - this.x;
        this.dy = mouseEvent.getY() - this.y;
        this.ui.setBounds(this.ui.getBounds().x + this.dx, this.ui.getBounds().y + this.dy, this.ui.getWidth(), this.ui.getHeight());
        Point point = this.ui.getLocation();
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.ui.setLocation(point);
        this.ui.getParent().repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

