/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.plugin.gmsh.mesh.PhysicalName;
import java.util.Arrays;

public class MeshFileEntity {
    private Vertex nodeElement = null;
    private MeshElement meshElement = null;
    private PhysicalName physicalName = null;
    private int nbNodeElement = -1;
    private int nbMeshElement = -1;
    private int nbPhysicalName = -1;
    private boolean finalEntity = false;
    private int[] physicalTags = null;

    public MeshFileEntity() {
        this.initialize();
    }

    public final void initialize() {
        this.nodeElement = null;
        this.meshElement = null;
        this.physicalName = null;
        this.finalEntity = false;
        this.nbMeshElement = -1;
        this.nbNodeElement = -1;
        this.nbPhysicalName = -1;
    }

    public void setNodeElement(Vertex nodeElement) {
        if (nodeElement == null) {
            throw new IllegalArgumentException("nodeElement cannot be null");
        }
        this.nodeElement = nodeElement;
    }

    public void setFinalEntity() {
        this.finalEntity = true;
    }

    public void setMeshElement(MeshElement meshElement) {
        if (meshElement == null) {
            throw new IllegalArgumentException("meshElement cannot be null");
        }
        this.meshElement = meshElement;
    }

    public void setNodeElementCount(int nbNode) {
        this.nbNodeElement = nbNode;
    }

    public void setMeshElementCount(int nbMeshElement) {
        this.nbMeshElement = nbMeshElement;
    }

    public void setPhysicalNameCount(int nbPhysical) {
        this.nbPhysicalName = nbPhysical;
    }

    public void setPhysicalTags(int[] tags) {
        this.physicalTags = tags;
    }

    public void setPhysicalName(PhysicalName physicalName) {
        this.physicalName = physicalName;
    }

    public MeshType getMeshType() {
        return this.meshElement.getMeshType();
    }

    public boolean isMeshElement() {
        return this.meshElement != null;
    }

    public boolean isNodeElement() {
        return this.nodeElement != null;
    }

    public boolean isMeshElementCount() {
        return this.nbMeshElement != -1;
    }

    public boolean isNodeElementCount() {
        return this.nbNodeElement != -1;
    }

    public boolean isPhysicalNameCount() {
        return this.nbPhysicalName != -1;
    }

    public boolean isPhysicalName() {
        return this.physicalName != null;
    }

    public boolean isFinalNode() {
        return this.finalEntity;
    }

    public boolean hasPhysicalTags() {
        return this.physicalTags != null;
    }

    public Vertex getVertex() {
        return this.nodeElement;
    }

    public MeshElement getMeshElement() {
        return this.meshElement;
    }

    public PhysicalName getPhysicalName() {
        return this.physicalName;
    }

    public int getNbNodeElement() {
        return this.nbNodeElement;
    }

    public int getNbMeshElement() {
        return this.nbMeshElement;
    }

    public int getNbPhysicalName() {
        return this.nbPhysicalName;
    }

    public int[] getPhysicalTags() {
        return this.physicalTags;
    }

    public String toString() {
        return "MeshFileEntity [nodeElement=" + this.nodeElement + ", meshElement=" + this.meshElement + ", physicalName=" + this.physicalName + ", nbNodeElement=" + this.nbNodeElement + ", nbMeshElement=" + this.nbMeshElement + ", nbPhysicalName=" + this.nbPhysicalName + ", finalEntity=" + this.finalEntity + ", physicalTags=" + Arrays.toString(this.physicalTags) + "]";
    }
}

