/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.ColorGradientSliderPanel;
import com.artenum.tk.color.ColorGradientThumb;
import com.artenum.tk.color.SliderMouseInputAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;

public class ColorGradientSliderUI
extends BasicSliderUI {
    private MouseInputAdapter mouseAdapter;
    private ChangeListener changeListener;
    private JSlider slider;
    private ColorGradientSliderPanel colorGradientPanel;
    private static Rectangle unionRect;

    public ColorGradientSliderUI() {
        super(null);
    }

    public ColorGradientSliderUI(ColorGradientSliderPanel panel) {
        super(panel.getSlider());
        this.colorGradientPanel = panel;
        this.slider = this.colorGradientPanel.getSlider();
        unionRect = new Rectangle();
    }

    @Override
    protected final void calculateThumbLocation() {
    }

    @Override
    protected final void calculateTrackRect() {
        super.calculateTrackRect();
        switch (this.colorGradientPanel.getOrientation()) {
            case 0: {
                int thumbHeight = 0;
                if (this.colorGradientPanel.isThumbsVisible()) {
                    thumbHeight = this.colorGradientPanel.getThumbsSize().height;
                }
                this.trackRect.height = Math.max(20 + thumbHeight, this.trackRect.height);
                break;
            }
            case 1: {
                int thumbWidth = 0;
                if (this.colorGradientPanel.isThumbsVisible()) {
                    thumbWidth = this.colorGradientPanel.getThumbsSize().width;
                }
                this.trackRect.width = Math.max(20 + thumbWidth, this.trackRect.width);
                break;
            }
        }
    }

    @Override
    protected final void calculateContentRect() {
        super.calculateContentRect();
    }

    protected final void calculateThumbsLocation() {
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int nbColors = this.colorGradientPanel.getNbColors();
        for (ColorGradientThumb thumb : this.colorGradientPanel.getThumbs()) {
            int y;
            int x;
            int sliderValue = (int)((double)minValue + (double)thumb.getColorIndex() / (double)(nbColors - 1) * (double)(maxValue - minValue));
            if (this.slider.getSnapToTicks()) {
                int tickSpacing = this.slider.getMinorTickSpacing();
                if (tickSpacing == 0) {
                    tickSpacing = this.slider.getMajorTickSpacing();
                }
                if (tickSpacing != 0) {
                    int snappedValue = sliderValue;
                    int min = this.slider.getMinimum();
                    if ((sliderValue - min) % tickSpacing != 0) {
                        float temp = (float)(sliderValue - min) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = min + whichTick * tickSpacing;
                        thumb.setColorIndex(snappedValue);
                    }
                }
            }
            if (this.colorGradientPanel.getOrientation() == 0) {
                x = this.xPositionForValue(sliderValue) - thumb.getSize().width / 2;
                y = this.trackRect.y;
            } else {
                x = this.trackRect.x;
                y = this.yPositionForValue(sliderValue) - thumb.getSize().height / 2;
            }
            thumb.setLocation(x, y);
        }
    }

    @Override
    public final void scrollByBlock(int direction) {
    }

    @Override
    public final void scrollByUnit(int direction) {
    }

    protected final void calculateThumbsSize() {
    }

    public final Rectangle getTrackRectangle() {
        return this.trackRect;
    }

    public final void setThumbLocation(ColorGradientThumb thumb, int x, int y) {
        Rectangle rect = thumb.getBounds();
        unionRect.setBounds(rect);
        thumb.setLocation(x, y);
        SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, unionRect);
        this.slider.repaint(ColorGradientSliderUI.unionRect.x, ColorGradientSliderUI.unionRect.y, ColorGradientSliderUI.unionRect.width, ColorGradientSliderUI.unionRect.height);
    }

    @Override
    public final void installUI(JComponent c) {
        this.slider = (JSlider)c;
        this.mouseAdapter = new SliderMouseInputAdapter(this.colorGradientPanel);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ColorGradientSliderUI.this.slider.getValueIsAdjusting()) {
                    ColorGradientSliderUI.this.calculateThumbsLocation();
                    ColorGradientSliderUI.this.slider.repaint();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorGradientSliderUI.this.superInstallUIMethod();
            }
        });
    }

    private void superInstallUIMethod() {
        super.installUI(this.slider);
    }

    @Override
    public final void uninstallUI(JComponent c) {
        this.slider = (JSlider)c;
        super.uninstallUI(this.slider);
        this.slider = null;
        this.mouseAdapter = null;
        this.changeListener = null;
    }

    @Override
    protected final BasicSliderUI.TrackListener createTrackListener(JSlider aSlider) {
        return null;
    }

    @Override
    protected final ChangeListener createChangeListener(JSlider aSlider) {
        return this.changeListener;
    }

    @Override
    protected final void installListeners(JSlider aSlider) {
        this.slider.addMouseListener(this.mouseAdapter);
        this.slider.addMouseMotionListener(this.mouseAdapter);
        this.slider.addFocusListener(this.focusListener);
        this.slider.addComponentListener(this.componentListener);
        this.slider.addPropertyChangeListener(this.propertyChangeListener);
        this.slider.getModel().addChangeListener(this.changeListener);
    }

    @Override
    protected final void uninstallListeners(JSlider aSlider) {
        this.slider.removeMouseListener(this.mouseAdapter);
        this.slider.removeMouseMotionListener(this.mouseAdapter);
        this.slider.removeFocusListener(this.focusListener);
        this.slider.removeComponentListener(this.componentListener);
        this.slider.removePropertyChangeListener(this.propertyChangeListener);
        this.slider.getModel().removeChangeListener(this.changeListener);
    }

    @Override
    protected final void calculateGeometry() {
        super.calculateGeometry();
        this.calculateThumbsSize();
        this.calculateThumbsLocation();
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.colorGradientPanel.isThumbsVisible()) {
            this.colorGradientPanel.getThumbs().iterator().next().paint(g);
        }
    }

    @Override
    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        int nbColors = this.colorGradientPanel.getNbColors();
        int nbTicks = this.colorGradientPanel.getNbTicks();
        int i = 0;
        double tickSpacing = (double)(nbColors - 1) / (double)(nbTicks - 1);
        g.setColor(Color.black);
        if (this.slider.getOrientation() == 0) {
            g.translate(0, tickBounds.y);
            int value = this.slider.getMinimum();
            int xPos = 0;
            if (nbTicks > 3) {
                value = this.slider.getMinimum();
                while (value <= this.slider.getMaximum()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                    value = (int)((double)i * tickSpacing);
                    ++i;
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            int yPos = 0;
            if (nbTicks > 3) {
                value = this.slider.getMinimum();
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    g.translate(2, 0);
                }
                i = 0;
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value = (int)((double)i * tickSpacing);
                    ++i;
                }
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    public final void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        super.paint(g, c);
        if (this.colorGradientPanel.isThumbsVisible()) {
            for (ColorGradientThumb thumb : this.colorGradientPanel.getThumbs()) {
                if (!clip.intersects(thumb.getBounds())) continue;
                thumb.paint(g);
            }
        }
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public final void paintTrack(Graphics g) {
        switch (this.colorGradientPanel.getOrientation()) {
            case 0: {
                int thumbsHeight = 0;
                if (this.colorGradientPanel.isThumbsVisible()) {
                    thumbsHeight = this.colorGradientPanel.getThumbsSize().height;
                }
                for (int i = this.trackRect.x; i < this.trackRect.x + this.trackRect.width; ++i) {
                    g.setColor(this.colorGradientPanel.getColorAt(i));
                    g.drawLine(i, this.trackRect.y + thumbsHeight, i, this.trackRect.y + this.trackRect.height);
                }
                break;
            }
            case 1: {
                int thumbsWidth = 0;
                if (this.colorGradientPanel.isThumbsVisible()) {
                    thumbsWidth = this.colorGradientPanel.getThumbsSize().width;
                }
                for (int j = this.trackRect.y; j < this.trackRect.y + this.trackRect.height; ++j) {
                    g.setColor(this.colorGradientPanel.getColorAt(j));
                    g.drawLine(this.trackRect.x + thumbsWidth, j, this.trackRect.x + this.trackRect.width, j);
                }
                break;
            }
            default: {
                super.paintTrack(g);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.colorGradientPanel.getSize();
    }
}

