/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import vtk.vtkLookupTable;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ScalarBarControlDialog
extends JDialog
implements ActionListener {
    private CassandraObject scalarBar;
    private JComboBox lookupTableComboBox;
    private JRadioButton horizontal;
    private JRadioButton vertical;
    private JTextField title;
    private JFormattedTextField x;
    private JFormattedTextField y;
    private JFormattedTextField width;
    private JFormattedTextField height;
    private JSpinner nbColor;
    private VtkObjectComboBoxModel lookupTableModel;
    private PipeLineManager pipelineManager;
    private JButton exit;
    private JButton update;

    public ScalarBarControlDialog(Frame parentFrame, final PipeLineManager pipelineManager) {
        super(parentFrame, "Scalar Bar control");
        this.pipelineManager = pipelineManager;
        this.lookupTableModel = new VtkObjectComboBoxModel(pipelineManager.getLookupTableList(), null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Title"));
        this.title = new JTextField();
        line.add((Component)this.title, "Center");
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        JPanel colA = new JPanel(new GridLayout(4, 0));
        JPanel colB = new JPanel(new GridLayout(4, 0));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Shape"));
        this.x = new JFormattedTextField((Object)"0");
        this.x.setValue(new Double(0.0));
        this.x.setColumns(20);
        this.y = new JFormattedTextField((Object)"0");
        this.y.setValue(new Double(0.0));
        this.width = new JFormattedTextField((Object)"0");
        this.width.setValue(new Double(0.0));
        this.height = new JFormattedTextField((Object)"0");
        this.height.setValue(new Double(0.0));
        colA.add(new JLabel("x : ", 4));
        colA.add(new JLabel("y : ", 4));
        colA.add(new JLabel("width : ", 4));
        colA.add(new JLabel("height : ", 4));
        colB.add(this.x);
        colB.add(this.y);
        colB.add(this.width);
        colB.add(this.height);
        line.add((Component)colA, "West");
        line.add((Component)colB, "Center");
        this.getContentPane().add(line);
        this.horizontal = new JRadioButton("Horizontal");
        this.vertical = new JRadioButton("Vertical");
        ButtonGroup group = new ButtonGroup();
        this.horizontal.addActionListener(this);
        this.vertical.addActionListener(this);
        group.add(this.horizontal);
        group.add(this.vertical);
        line = new JPanel(new GridLayout(1, 2));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Orientation"));
        line.add(this.horizontal);
        line.add(this.vertical);
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Lookup table"));
        this.lookupTableComboBox = new JComboBox(this.lookupTableModel);
        line.add((Component)this.lookupTableComboBox, "Center");
        this.getContentPane().add(line);
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalarBarControlDialog.this.updateScalarBar();
                pipelineManager.validateViewAndGo();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalarBarControlDialog.this.dispose();
            }
        });
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(this.update);
        line.add(this.exit);
        this.getContentPane().add(line);
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    public void setScalarBar(CassandraObject scalarBar) {
        this.scalarBar = scalarBar;
        this.width.setValue(new Double(this.getVtkScalarBar().GetWidth()));
        this.height.setValue(new Double(this.getVtkScalarBar().GetHeight()));
        double[] xy = this.getVtkScalarBar().GetPosition();
        this.x.setValue(new Double(xy[0]));
        this.y.setValue(new Double(xy[1]));
        this.title.setText(this.getVtkScalarBar().GetTitle());
        this.vertical.setSelected(this.getVtkScalarBar().GetOrientation() == 1);
        this.lookupTableModel.setSelectedEncapsulateItem(this.getVtkScalarBar().GetLookupTable());
    }

    public void updateScalarBar() {
        this.getVtkScalarBar().SetWidth(((Number)this.width.getValue()).doubleValue());
        this.getVtkScalarBar().SetHeight(((Number)this.height.getValue()).doubleValue());
        this.getVtkScalarBar().SetPosition(((Number)this.x.getValue()).doubleValue(), ((Number)this.y.getValue()).doubleValue());
        this.getVtkScalarBar().SetTitle(this.title.getText());
        if (this.horizontal.isSelected()) {
            this.getVtkScalarBar().SetOrientationToHorizontal();
        } else {
            this.getVtkScalarBar().SetOrientationToVertical();
        }
        this.getVtkScalarBar().SetLookupTable((vtkScalarsToColors)((vtkLookupTable)((CassandraObject)this.lookupTableModel.getSelectedItem()).getVtkObject()));
        this.pipelineManager.notifyConnectivityChange(this.scalarBar);
    }

    public vtkScalarBarActor getVtkScalarBar() {
        return (vtkScalarBarActor)this.scalarBar.getVtkObject();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Number oldX = (Number)this.x.getValue();
        Number oldY = (Number)this.y.getValue();
        Number oldWidth = (Number)this.width.getValue();
        Number oldHeight = (Number)this.height.getValue();
        this.x.setValue(oldY);
        this.y.setValue(oldX);
        this.height.setValue(oldWidth);
        this.width.setValue(oldHeight);
    }
}

