/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import vtk.vtkTextActor;

public class TxtActorControlDialog
extends JDialog {
    private PipeLineManager pipelineManager;
    private CassandraObject currentVtkObject;
    private JTextField txtContent;
    private JFormattedTextField posX;
    private JFormattedTextField posY;
    private JFormattedTextField fontSize;
    private JButton color;
    private JButton exit;
    private JButton update;

    public TxtActorControlDialog(final Frame parentFrame, final PipeLineManager pipelineManager) {
        super(parentFrame, "Text control");
        this.pipelineManager = pipelineManager;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Text content"));
        this.txtContent = new JTextField();
        line.add((Component)this.txtContent, "Center");
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        JPanel colA = new JPanel(new GridLayout(4, 0));
        JPanel colB = new JPanel(new GridLayout(4, 0));
        this.posX = new JFormattedTextField((Object)"0");
        this.posX.setValue(new Double(0.0));
        this.posX.setColumns(20);
        this.posY = new JFormattedTextField((Object)"0");
        this.posY.setValue(new Double(0.0));
        this.fontSize = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.color = new JButton();
        this.color.setBackground(Color.WHITE);
        colA.add(new JLabel("X : ", 4));
        colA.add(new JLabel("Y : ", 4));
        colA.add(new JLabel("Font size : ", 4));
        colA.add(new JLabel("Color : ", 4));
        colB.add(this.posX);
        colB.add(this.posY);
        colB.add(this.fontSize);
        colB.add(this.color);
        line.add((Component)colA, "West");
        line.add((Component)colB, "Center");
        this.getContentPane().add(line);
        this.color.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                vtkTextActor vtkTxtActor = (vtkTextActor)TxtActorControlDialog.this.currentVtkObject.getVtkObject();
                Color result = JColorChooser.showDialog(parentFrame, "Text color", CassandraToolBox.vtkColorConverter(vtkTxtActor.GetTextProperty().GetColor()));
                if (result != null) {
                    TxtActorControlDialog.this.color.setBackground(result);
                    vtkTxtActor.GetTextProperty().SetColor(CassandraToolBox.vtkColorConverter(result));
                }
                pipelineManager.validateViewAndGo();
            }
        });
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double x = ((Number)TxtActorControlDialog.this.posX.getValue()).doubleValue();
                double y = ((Number)TxtActorControlDialog.this.posY.getValue()).doubleValue();
                int size = ((Number)TxtActorControlDialog.this.fontSize.getValue()).intValue();
                vtkTextActor vtkTxtActor = (vtkTextActor)TxtActorControlDialog.this.currentVtkObject.getVtkObject();
                vtkTxtActor.SetPosition(x, y);
                vtkTxtActor.SetInput(TxtActorControlDialog.this.txtContent.getText());
                vtkTxtActor.GetTextProperty().SetFontSize(size);
                pipelineManager.validateViewAndGo();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxtActorControlDialog.this.dispose();
            }
        });
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(this.update);
        line.add(this.exit);
        this.getContentPane().add(line);
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    public void setTxtActor(CassandraObject currentTxtActor) {
        this.currentVtkObject = currentTxtActor;
        vtkTextActor vtkTxtActor = (vtkTextActor)this.currentVtkObject.getVtkObject();
        this.posX.setValue(new Double(vtkTxtActor.GetPosition()[0]));
        this.posY.setValue(new Double(vtkTxtActor.GetPosition()[1]));
        this.fontSize.setValue(new Integer(vtkTxtActor.GetTextProperty().GetFontSize()));
        this.txtContent.setText(vtkTxtActor.GetInput());
    }
}

