/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.VtkObjectInformationPane;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vtk.vtkActor;
import vtk.vtkActor2D;

public class ActorPopupMenu
extends JPopupMenu
implements ActionListener,
ChangeListener,
VtkObjectPopupMenu {
    public static final String ACTOR_SHOW = "actor.show";
    public static final String ACTOR_COLOR = "actor.color";
    public static final String ACTOR_REMOVE = "actor.remove";
    public static final String CHANG_REP = "actor.change.representation";
    public static final String SHOW_HIDE_EDGES = "actor.edge.status";
    public static final String EDGES_COLOR = "edges.color";
    public static final String ACTOR_REP_POINT = "Points";
    public static final String ACTOR_REP_WIREFRAME = "Wireframe";
    public static final String ACTOR_REP_SURFACE = "Surface";
    public static final String ACTOR_GET_INFO = "actor.get.info";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;
    private JCheckBoxMenuItem viewActor;
    private JSlider actorOpacity;
    private JMenuItem actorColor;
    private RenameVtkObject actorRename;
    private JMenuItem actorGetInfo;
    private JMenuItem actorRemove;
    private JCheckBox edgesCheckBox;
    private ButtonGroup actorRepresentation;
    private JRadioButton pointButton;
    private JRadioButton surfaceButton;
    private JRadioButton wireframeButton;
    private JCheckBox backFaceCullingCheckBox;
    private JButton edgeColorButton;
    private double rEdge = 0.5;
    private double gEdge = 0.5;
    private double bEdge = 0.5;

    public ActorPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.viewActor = new JCheckBoxMenuItem("Visible");
        this.viewActor.setActionCommand(ACTOR_SHOW);
        this.viewActor.addActionListener(this);
        this.actorColor = new JMenuItem("Actor color");
        this.actorColor.setActionCommand(ACTOR_COLOR);
        this.actorColor.addActionListener(this);
        this.actorOpacity = new JSlider(0, 50, 50);
        this.actorOpacity.addChangeListener(this);
        Hashtable<Integer, JLabel> label = new Hashtable<Integer, JLabel>();
        label.put(new Integer(0), new JLabel("0%"));
        label.put(new Integer(50), new JLabel("100%"));
        label.put(new Integer(25), new JLabel("50%"));
        this.actorOpacity.setMinorTickSpacing(1);
        this.actorOpacity.setMajorTickSpacing(5);
        this.actorOpacity.setLabelTable(label);
        this.actorOpacity.setPaintLabels(true);
        this.actorOpacity.setPaintLabels(true);
        this.actorRename = new RenameVtkObject("Rename", "Rename actor", null);
        this.actorGetInfo = new JMenuItem("Get information");
        this.actorGetInfo.setActionCommand(ACTOR_GET_INFO);
        this.actorGetInfo.addActionListener(this);
        this.actorRemove = new JMenuItem("Remove");
        this.actorRemove.setActionCommand(ACTOR_REMOVE);
        this.actorRemove.addActionListener(this);
        Box edgesBox = Box.createHorizontalBox();
        this.edgesCheckBox = new JCheckBox("show edges");
        this.edgesCheckBox.addChangeListener(this);
        this.edgesCheckBox.setActionCommand(SHOW_HIDE_EDGES);
        edgesBox.add(this.edgesCheckBox);
        this.edgeColorButton = new JButton("Edges color");
        this.edgeColorButton.addActionListener(this);
        this.edgeColorButton.setActionCommand(EDGES_COLOR);
        edgesBox.add(this.edgeColorButton);
        this.actorRepresentation = new ButtonGroup();
        this.pointButton = new JRadioButton(ACTOR_REP_POINT);
        this.actorRepresentation.add(this.pointButton);
        this.pointButton.addChangeListener(this);
        this.surfaceButton = new JRadioButton(ACTOR_REP_SURFACE);
        this.actorRepresentation.add(this.surfaceButton);
        this.surfaceButton.addChangeListener(this);
        this.wireframeButton = new JRadioButton(ACTOR_REP_WIREFRAME);
        this.actorRepresentation.add(this.wireframeButton);
        this.wireframeButton.addChangeListener(this);
        Box representationMenu = Box.createVerticalBox();
        representationMenu.add(new JLabel("Represent as:"));
        representationMenu.add(this.pointButton);
        representationMenu.add(this.surfaceButton);
        representationMenu.add(this.wireframeButton);
        this.backFaceCullingCheckBox = new JCheckBox("set back face culling");
        this.backFaceCullingCheckBox.addChangeListener(this);
        this.add(this.viewActor);
        this.add(this.actorOpacity);
        this.addSeparator();
        this.add(edgesBox);
        this.addSeparator();
        this.add(representationMenu);
        this.add(this.backFaceCullingCheckBox);
        this.addSeparator();
        this.add(this.actorColor);
        this.addSeparator();
        this.add(this.actorRename);
        this.add(this.actorGetInfo);
        this.addSeparator();
        this.add(this.actorRemove);
    }

    @Override
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        this.actorRename.setVtkObject(currentVtkObject);
        this.actorColor.setEnabled(currentVtkObject.getVtkObject() instanceof vtkActor);
        if (currentVtkObject.getVtkObject() instanceof vtkActor) {
            this.actorOpacity.setValue((int)(((vtkActor)currentVtkObject.getVtkObject()).GetProperty().GetOpacity() * 50.0));
        }
        if (currentVtkObject.getVtkObject() instanceof vtkActor2D) {
            this.actorOpacity.setValue((int)(((vtkActor2D)currentVtkObject.getVtkObject()).GetProperty().GetOpacity() * 50.0));
        }
        if (currentVtkObject.getMetaData().get("ACTOR_VISIBLE") == null) {
            this.viewActor.setSelected(false);
        } else {
            this.viewActor.setSelected(((String)currentVtkObject.getMetaData().get("ACTOR_VISIBLE")).equals("true"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color c;
        String command = e.getActionCommand();
        if (command.equals(ACTOR_SHOW)) {
            this.pipeLineManager.setActorVisible(this.currentVtkObject, this.viewActor.isSelected());
        } else if (command.equals(ACTOR_COLOR)) {
            Color c2 = JColorChooser.showDialog(this, "Actor color", Color.BLACK);
            if (c2 != null) {
                double r = (float)c2.getRed() / 255.0f;
                double g = (float)c2.getGreen() / 255.0f;
                double b = (float)c2.getBlue() / 255.0f;
                if (this.currentVtkObject.getVtkObject() instanceof vtkActor) {
                    ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetColor(r, g, b);
                }
                ((vtkActor)this.currentVtkObject.getVtkObject()).ApplyProperties();
            }
        } else if (command.equals(ACTOR_GET_INFO)) {
            VtkObjectInformationPane infoPane = new VtkObjectInformationPane(this.currentVtkObject);
            infoPane.showMessageDialog();
        } else if (command.equals(ACTOR_REMOVE)) {
            this.cascadeRemoveManager.removeActor(this.currentVtkObject);
        } else if (command.equals(EDGES_COLOR) && (c = JColorChooser.showDialog(this, "Actor color", Color.BLACK)) != null) {
            this.rEdge = (float)c.getRed() / 255.0f;
            this.gEdge = (float)c.getGreen() / 255.0f;
            this.bEdge = (float)c.getBlue() / 255.0f;
            if (this.currentVtkObject.getVtkObject() instanceof vtkActor) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetEdgeColor(this.rEdge, this.gEdge, this.bEdge);
            }
        }
        this.pipeLineManager.validateViewAndGo();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.currentVtkObject.getVtkObject() instanceof vtkActor) {
            ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetOpacity((double)this.actorOpacity.getValue() / 50.0);
            if (this.edgesCheckBox.isSelected()) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetEdgeColor(this.rEdge, this.gEdge, this.bEdge);
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetEdgeVisibility(1);
            } else {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetEdgeVisibility(0);
            }
            if (this.backFaceCullingCheckBox.isSelected()) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetBackfaceCulling(1);
            } else {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetBackfaceCulling(0);
            }
            if (this.pointButton.isSelected()) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetRepresentationToPoints();
            } else if (this.wireframeButton.isSelected()) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetRepresentationToWireframe();
            } else if (this.surfaceButton.isSelected()) {
                ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetRepresentationToSurface();
            }
            ((vtkActor)this.currentVtkObject.getVtkObject()).ApplyProperties();
        } else if (this.currentVtkObject.getVtkObject() instanceof vtkActor2D) {
            ((vtkActor2D)this.currentVtkObject.getVtkObject()).GetProperty().SetOpacity((double)this.actorOpacity.getValue() / 50.0);
        }
        this.pipeLineManager.validateViewAndGo();
    }

    public JMenuItem getActorColorMenuItem() {
        return this.actorColor;
    }

    public JSlider getActorOpacityMenuItem() {
        return this.actorOpacity;
    }

    public JMenuItem getActorRemoveMenuItem() {
        return this.actorRemove;
    }

    public JMenuItem getActorRenameMenuItem() {
        return this.actorRename;
    }

    public JCheckBoxMenuItem getActorVisibleMenuItem() {
        return this.viewActor;
    }
}

