/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.VtkObjectInformationPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DataSetPopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String DATASET_REMOVE = "dataset.remove";
    public static final String DATASET_GET_INFO = "dataset.get.info";
    public static final String DATASET_SAVE = "dataset.save";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;
    private RenameVtkObject datasetRename;
    private JMenuItem datasetRemove;
    private JMenuItem datasetGetInfo;
    private JMenuItem dataSetSave;

    public DataSetPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.datasetRename = new RenameVtkObject("Rename", "Rename dataset", null);
        this.add(this.datasetRename);
        this.datasetGetInfo = new JMenuItem("Get information");
        this.datasetGetInfo.setActionCommand(DATASET_GET_INFO);
        this.datasetGetInfo.addActionListener(this);
        this.add(this.datasetGetInfo);
        this.addSeparator();
        this.datasetRemove = new JMenuItem("Remove");
        this.datasetRemove.setActionCommand(DATASET_REMOVE);
        this.datasetRemove.addActionListener(this);
        this.add(this.datasetRemove);
    }

    @Override
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        this.datasetRename.setVtkObject(currentVtkObject);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(DATASET_REMOVE)) {
            this.cascadeRemoveManager.removeDataSet(this.currentVtkObject);
        } else if (command.equals(DATASET_GET_INFO)) {
            VtkObjectInformationPane infoPane = new VtkObjectInformationPane(this.currentVtkObject);
            infoPane.showMessageDialog();
        }
    }
}

