/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.FileComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JPopupMenu;
import vtk.vtkIVExporter;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkOBJExporter;
import vtk.vtkOOGLExporter;
import vtk.vtkRIBExporter;
import vtk.vtkRenderWindow;
import vtk.vtkVRMLExporter;

public class CassandraToolBox {
    public static Frame getParentFrame(Component c) {
        Component currentComponent = c;
        while (currentComponent != null && !(currentComponent instanceof Frame)) {
            if (currentComponent instanceof JPopupMenu) {
                currentComponent = ((JPopupMenu)currentComponent).getInvoker();
                continue;
            }
            currentComponent = currentComponent.getParent();
        }
        return (Frame)currentComponent;
    }

    public static Dialog getParentDialog(Component c) {
        Component currentComponent = c;
        while (currentComponent != null && !(currentComponent instanceof Dialog)) {
            if (currentComponent instanceof JPopupMenu) {
                currentComponent = ((JPopupMenu)currentComponent).getInvoker();
                continue;
            }
            currentComponent = currentComponent.getParent();
        }
        return (Dialog)currentComponent;
    }

    public static void updateMapper(PipeLineManager pipelineManager, vtkLookupTable lookupTable) {
        Iterator<CassandraObject> i = pipelineManager.getMapperList().getData().iterator();
        while (i.hasNext()) {
            vtkMapper mapper = (vtkMapper)i.next().getVtkObject();
            if (!mapper.GetLookupTable().equals(lookupTable)) continue;
            mapper.SetScalarRange(lookupTable.GetTableRange());
        }
    }

    public static void updateLookupTableRange(vtkLookupTable lookupTable, double min, double max) {
        double realMin = lookupTable.GetTableRange()[0];
        double realMax = lookupTable.GetTableRange()[1];
        if (realMin > min) {
            realMin = min;
        }
        if (realMax < max) {
            realMax = max;
        }
        lookupTable.SetRange(realMin, realMax);
        lookupTable.Build();
    }

    public static Color vtkColorConverter(double r, double g, double b) {
        return new Color((float)r, (float)g, (float)b);
    }

    public static double[] vtkColorConverter(Color c) {
        double[] rgb = new double[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f};
        return rgb;
    }

    public static Color vtkColorConverter(double[] rvb) {
        return CassandraToolBox.vtkColorConverter(rvb[0], rvb[1], rvb[2]);
    }

    public static ArrayList splitNumbers(String fileNameToSplit) {
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        StringBuffer number = null;
        StringBuffer text = null;
        int numberID = 1;
        int stringID = 2;
        int currentID = -1;
        for (int i = 0; i < fileNameToSplit.length(); ++i) {
            if (fileNameToSplit.charAt(i) >= '0' && fileNameToSplit.charAt(i) <= '9') {
                if (currentID == stringID || currentID == -1) {
                    currentID = numberID;
                    number = new StringBuffer();
                    result.add(number);
                }
                number.append(fileNameToSplit.charAt(i));
                continue;
            }
            if (currentID == numberID || currentID == -1) {
                currentID = stringID;
                text = new StringBuffer();
                result.add(text);
            }
            text.append(fileNameToSplit.charAt(i));
        }
        return result;
    }

    public static void sortFileList(File[] fileListToSort) {
        Arrays.sort(fileListToSort, new FileComparator());
    }

    public static void saveObject(Object obj, String fileName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.close();
    }

    public static Object loadObject(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object readObject = ois.readObject();
        ois.close();
        fis.close();
        return readObject;
    }

    public static void export3DScene(String filename, vtkRenderWindow input) throws Exception {
        long start = System.currentTimeMillis();
        vtkIVExporter exporter1 = new vtkIVExporter();
        exporter1.SetInput(input);
        exporter1.SetFileName(filename + ".oiv");
        exporter1.Update();
        System.out.println("OpenInventor: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        vtkOOGLExporter exporter2 = new vtkOOGLExporter();
        exporter2.SetInput(input);
        exporter2.SetFileName(filename + ".geom");
        exporter2.Update();
        System.out.println("OOGL: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        vtkOBJExporter exporter3 = new vtkOBJExporter();
        exporter3.SetInput(input);
        exporter3.SetFilePrefix(filename);
        exporter3.Update();
        System.out.println("OBJ: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        vtkRIBExporter exporter4 = new vtkRIBExporter();
        exporter4.SetInput(input);
        exporter4.SetFilePrefix(filename);
        exporter4.Update();
        System.out.println("RIB: " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        vtkVRMLExporter exporter = new vtkVRMLExporter();
        exporter.SetInput(input);
        exporter.SetFileName(filename + ".wrl");
        exporter.Update();
        System.out.println("VRML: " + (System.currentTimeMillis() - start));
    }

    public static void export3DScene(vtkRenderWindow input) throws Exception {
        long start = System.currentTimeMillis();
        byte[] buffer = new byte[0x100000];
        int length = -1;
        start = System.currentTimeMillis();
        vtkVRMLExporter exporter = new vtkVRMLExporter();
        exporter.SetInput(input);
        exporter.SetFileName("tmp.wrl");
        exporter.Update();
        FileInputStream fis = new FileInputStream("scene.wrl");
        BufferedInputStream bis = new BufferedInputStream(fis);
        FileOutputStream fos = new FileOutputStream("scene.zip");
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ZipOutputStream zos = new ZipOutputStream(bos);
        ZipEntry entry = new ZipEntry("scene3D.wrl");
        zos.putNextEntry(entry);
        while ((length = bis.read(buffer)) != -1) {
            zos.write(buffer, 0, length);
        }
        zos.closeEntry();
        zos.close();
        fis.close();
        bis.close();
        fos.close();
        System.out.println("VRML: " + (System.currentTimeMillis() - start));
    }
}

