/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.IsoLevelPipeLine;
import java.util.ArrayList;
import vtk.vtkDataSet;
import vtk.vtkProp;

public class IsoLevelAnimation
extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;
    private double stepSize;

    public IsoLevelAnimation(PipeLineManager pipeLineManager, vtkDataSet dataset, double levelA, double levelB, int nbStep, boolean normal, boolean register) {
        this.dataset = dataset;
        this.pipeLineManager = pipeLineManager;
        this.list = new ArrayList();
        this.stepSize = (levelB - levelA) / (double)nbStep;
        for (int i = 0; i < nbStep; ++i) {
            IsoLevelPipeLine pipe = new IsoLevelPipeLine(dataset, levelA + (double)i * this.stepSize, normal);
            if (register) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor(pipe.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor((vtkProp)pipe.getActor());
            }
            this.list.add(pipe);
        }
        this.setPriority(1);
    }

    @Override
    public void run() {
        IsoLevelPipeLine currentPipe2 = null;
        IsoLevelPipeLine previousPipe = null;
        ArrayList<IsoLevelPipeLine> tmpList = new ArrayList<IsoLevelPipeLine>();
        while (this.keepGoing) {
            for (IsoLevelPipeLine currentPipe2 : this.list) {
                tmpList.add(currentPipe2);
                currentPipe2.getActor().SetVisibility(1);
                if (previousPipe != null) {
                    previousPipe.getActor().SetVisibility(0);
                }
                previousPipe = currentPipe2;
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    IsoLevelAnimation.sleep(this.speed);
                }
                catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
            while (!tmpList.isEmpty()) {
                currentPipe2 = (IsoLevelPipeLine)tmpList.remove(tmpList.size() - 1);
                currentPipe2.getActor().SetVisibility(1);
                if (previousPipe != null) {
                    previousPipe.getActor().SetVisibility(0);
                }
                previousPipe = currentPipe2;
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    IsoLevelAnimation.sleep(this.speed);
                }
                catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        this.keepGoing = false;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setReduction(double reduction) {
        this.reduction = reduction;
    }
}

