/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.impl;

import com.artenum.graph.impl.DefaultConnection;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class DefaultCell
implements Cell {
    protected Object oldGroupDragListener;
    protected Component ui;
    protected ArrayList connectionList;
    protected Object userObject;
    protected boolean selected;
    protected Color selectedBorderColor = Color.BLUE;
    protected int selectedBorderSize = 2;

    public DefaultCell(Object object, Component component) {
        this.userObject = object;
        this.ui = component;
        this.connectionList = new ArrayList();
    }

    public Component getUI() {
        return this.ui;
    }

    public List getConnections() {
        return this.connectionList;
    }

    public Point getConnectionPoint(Connection connection) {
        return new Point((int)this.ui.getBounds().getCenterX(), (int)this.ui.getBounds().getCenterY());
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (this.ui != null && this.ui instanceof JComponent) {
            if (bl) {
                ((JComponent)this.ui).setBorder(BorderFactory.createLineBorder(this.selectedBorderColor, this.selectedBorderSize));
            } else {
                ((JComponent)this.ui).setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void connectTo(Cell cell) {
        DefaultConnection defaultConnection = new DefaultConnection(this, cell);
        this.addConnection(defaultConnection);
        cell.addConnection(defaultConnection);
    }

    public void addConnection(Connection connection) {
        this.connectionList.add(connection);
    }

    public void addGroupDragListener(Object object) {
        if (this.oldGroupDragListener != null) {
            this.ui.removeMouseListener((MouseListener)this.oldGroupDragListener);
            this.ui.removeMouseMotionListener((MouseMotionListener)this.oldGroupDragListener);
        }
        this.ui.addMouseListener((MouseListener)object);
        this.ui.addMouseMotionListener((MouseMotionListener)object);
        this.oldGroupDragListener = object;
    }

    public void setSelectedBorderColor(Color color) {
        this.selectedBorderColor = color;
    }

    public void setSelectedBorderSize(int n) {
        this.selectedBorderSize = n;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }
}

