/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.CassandraObject;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VtkObjectListModel
extends AbstractListModel
implements ListCellRenderer {
    private static final long serialVersionUID = -7207648389874912760L;
    private final ArrayList<CassandraObject> vtkObjectList = new ArrayList();
    private final JLabel renderer = new JLabel();
    private Color selectedColor;
    private Color defaultColor;
    private final int modelType;
    private boolean showTypeError = false;

    public VtkObjectListModel(int modelType) {
        this.renderer.setOpaque(true);
        this.selectedColor = new Color(100, 100, 200);
        this.defaultColor = Color.white;
        this.modelType = modelType;
    }

    public void setPrefference(Color selectedColor, Color defaultColor, boolean showTypeError) {
        if (selectedColor != null) {
            this.selectedColor = selectedColor;
        }
        if (defaultColor != null) {
            this.defaultColor = defaultColor;
        }
        this.showTypeError = showTypeError;
    }

    @Override
    public int getSize() {
        return this.vtkObjectList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.vtkObjectList.get(index);
    }

    public void addVtkObject(CassandraObject cassObject) {
        if (cassObject.getType() == this.modelType) {
            this.vtkObjectList.add(cassObject);
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        } else if (this.showTypeError) {
            System.err.println("Try to ADD invalide type in the VtkObjectListModel. (Expected: " + this.modelType + " / Got: " + cassObject.getType() + ")");
        }
    }

    public void removeVtkObject(CassandraObject vtkObject2) {
        if (vtkObject2.getType() == this.modelType) {
            int index = this.vtkObjectList.indexOf(vtkObject2);
            if (index != -1) {
                this.vtkObjectList.remove(index);
            }
            this.fireIntervalRemoved(this, index, index);
        } else if (this.showTypeError) {
            System.err.println("Try to REMOVE invalide type in the VtkObjectListModel. (Expected: " + this.modelType + " / Got: " + vtkObject2.getType() + ")");
        }
    }

    public CassandraObject getVtkObject(int index) {
        return (CassandraObject)this.getElementAt(index);
    }

    public CassandraObject getVtkObject(Object encapsulateObject) {
        for (CassandraObject currentObject : this.vtkObjectList) {
            if (!currentObject.getVtkObject().equals(encapsulateObject)) continue;
            return currentObject;
        }
        return null;
    }

    public int getVtkObjectIndex(CassandraObject vtkObject2) {
        return this.vtkObjectList.indexOf(vtkObject2);
    }

    public CassandraObject getLastVtkObject() {
        return this.getVtkObject(this.getSize() - 1);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderer.setBackground(isSelected ? this.selectedColor : this.defaultColor);
        CassandraObject vtkObject2 = (CassandraObject)value;
        this.renderer.setText(vtkObject2.getName() + " (" + index + ")");
        return this.renderer;
    }

    public Collection<CassandraObject> getData() {
        return this.vtkObjectList;
    }
}

