/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin;

import com.artenum.cassandra.action.PluginActionListener;
import com.artenum.cassandra.plugin.CassandraPlugin;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class PluginManager
extends AbstractListModel
implements ListCellRenderer {
    private static final long serialVersionUID = -2101549386851091131L;
    private final ArrayList<CassandraPlugin> pluginList = new ArrayList();
    private final JLabel renderer;
    private final Color selectedColor;
    private final Color defaultColor;
    private List<PluginActionListener> pluginActionListenerList = new ArrayList<PluginActionListener>();

    public PluginManager() {
        this.renderer = new JLabel();
        this.renderer.setOpaque(true);
        this.selectedColor = new Color(100, 100, 200);
        this.defaultColor = Color.white;
    }

    @Override
    public int getSize() {
        return this.pluginList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.pluginList.get(index);
    }

    public void addPlugin(CassandraPlugin plugin) {
        this.pluginList.add(plugin);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
    }

    public void removePlugin(CassandraPlugin plugin) {
        int index = this.pluginList.indexOf(plugin);
        if (index != -1) {
            this.pluginList.remove(index);
        }
        this.fireIntervalRemoved(this, index, index);
    }

    public CassandraPlugin getPlugin(int index) {
        return this.pluginList.get(index);
    }

    public CassandraPlugin getLastPlugin() {
        return this.getPlugin(this.getSize() - 1);
    }

    public Collection<CassandraPlugin> getData() {
        return this.pluginList;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderer.setBackground(isSelected ? this.selectedColor : this.defaultColor);
        this.renderer.setText(value.toString() + " (" + index + ")");
        return this.renderer;
    }

    public boolean addPluginActionListener(PluginActionListener actionListener) {
        return this.pluginActionListenerList.add(actionListener);
    }

    public boolean removePluginActionListener(PluginActionListener actionListener) {
        return this.pluginActionListenerList.remove(actionListener);
    }

    public List<PluginActionListener> getPluginActionListenerList() {
        return this.pluginActionListenerList;
    }
}

