/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin;

import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import java.util.HashMap;

public class SimplePlugInProperty
implements CassandraPlugInProperty {
    private String name;
    private HashMap propList = new HashMap();

    @Override
    public void put(Object key, Object prop) {
        this.propList.put(key, prop);
    }

    @Override
    public Object get(Object key) {
        return this.propList.get(key);
    }

    @Override
    public Object getSafely(Object key, Object defaultValue) {
        return this.getObjectSafely(key, defaultValue);
    }

    private Object getObjectSafely(Object key, Object defaultValue) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        System.err.println("key " + key.toString() + " not found. Value set to default");
        return defaultValue;
    }

    @Override
    public double getSafely(Object key, double defaultValue) {
        try {
            return (Double)this.getObjectSafely(key, defaultValue);
        }
        catch (Exception e) {
            System.err.println("Property not understood or impossible to cast. Set to the default value");
            return defaultValue;
        }
    }

    @Override
    public int getSafely(Object key, int defaultValue) {
        try {
            return (Integer)this.getObjectSafely(key, defaultValue);
        }
        catch (Exception e) {
            System.err.println("Property not understood or impossible to cast. Set to the default value");
            return defaultValue;
        }
    }

    @Override
    public float getSafely(Object key, float defaultValue) {
        try {
            return ((Float)this.getObjectSafely(key, Float.valueOf(defaultValue))).floatValue();
        }
        catch (Exception e) {
            System.err.println("Property not understood or impossible to cast. Set to the default value");
            return defaultValue;
        }
    }

    @Override
    public HashMap getPropertyMap() {
        return this.propList;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.propList.containsKey(key);
    }
}

