/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.nisaba.util;

import com.artenum.nisaba.util.VectorUtilDouble;
import java.util.Arrays;

public class Quaternion {
    private double[] quaternion = new double[]{0.0, 0.0, 1.0, 0.0};

    public Quaternion() {
    }

    public Quaternion(double angleRadius, double ... axis) {
        this();
        this.setAngleAxis(angleRadius, axis);
    }

    public Quaternion(Quaternion q) {
        this();
        for (int i = 0; i < 4; ++i) {
            this.quaternion[i] = q.quaternion[i];
        }
    }

    public void setQuaternionXYZW(double x, double y, double z, double w) {
        this.quaternion[0] = x;
        this.quaternion[1] = y;
        this.quaternion[2] = z;
        this.quaternion[3] = w;
    }

    public Quaternion setAngleAxis(double angleRadius, double ... axis) {
        double cos;
        double sin = Math.sin(angleRadius / 2.0);
        this.quaternion[3] = cos = Math.cos(angleRadius / 2.0);
        double[] normalizedAxis = VectorUtilDouble.copy(axis);
        VectorUtilDouble.normalize3(normalizedAxis);
        this.quaternion[0] = sin * normalizedAxis[0];
        this.quaternion[1] = sin * normalizedAxis[1];
        this.quaternion[2] = sin * normalizedAxis[2];
        this.normalize();
        return this;
    }

    public double getAngle() {
        return Math.acos(this.quaternion[3]) * 2.0;
    }

    public double[] getAxis() {
        double[] axis = VectorUtilDouble.copy3(this.quaternion);
        VectorUtilDouble.normalize3(axis);
        return axis;
    }

    public void getTransform(double[] outputBuffer) {
        double vx = this.quaternion[0];
        double vy = this.quaternion[1];
        double vz = this.quaternion[2];
        double ww = this.quaternion[3];
        double xx = vx * vx;
        double xy = vx * vy;
        double xz = vx * vz;
        double xw = vx * ww;
        double yy = vy * vy;
        double yz = vy * vz;
        double yw = vy * ww;
        double zz = vz * vz;
        double zw = vz * ww;
        outputBuffer[0] = 1.0 - 2.0 * (yy + zz);
        outputBuffer[1] = 2.0 * (xy - zw);
        outputBuffer[2] = 2.0 * (xz + yw);
        outputBuffer[3] = 2.0 * (xy + zw);
        outputBuffer[4] = 1.0 - 2.0 * (xx + zz);
        outputBuffer[5] = 2.0 * (yz - xw);
        outputBuffer[6] = 2.0 * (xz - yw);
        outputBuffer[7] = 2.0 * (yz + xw);
        outputBuffer[8] = 1.0 - 2.0 * (xx + yy);
    }

    public static boolean compare(double a, double b, double tolerance) {
        return a == b ? true : Math.abs(a - b) < tolerance;
    }

    public static boolean compare(Quaternion q1, Quaternion q2, double tolerance) {
        return Quaternion.compare(q1.quaternion[0], q2.quaternion[0], tolerance) && Quaternion.compare(q1.quaternion[1], q2.quaternion[1], tolerance) && Quaternion.compare(q1.quaternion[2], q2.quaternion[2], tolerance) && Quaternion.compare(q1.quaternion[3], q2.quaternion[3], tolerance) || Quaternion.compare(-q1.quaternion[0], q2.quaternion[0], tolerance) && Quaternion.compare(-q1.quaternion[1], q2.quaternion[1], tolerance) && Quaternion.compare(-q1.quaternion[2], q2.quaternion[2], tolerance) && Quaternion.compare(-q1.quaternion[3], q2.quaternion[3], tolerance);
    }

    public void normalize() {
        VectorUtilDouble.div(this.quaternion, VectorUtilDouble.norm(this.quaternion));
    }

    public String toString() {
        return Arrays.toString(this.quaternion);
    }
}

