/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.threshold.ThresholdPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import vtk.vtkDataSet;

public class ThresholdControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private ThresholdPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField lowerLevel;
    private JFormattedTextField upperLevel;
    private JRadioButton thresholdBetween;
    private JRadioButton thresholdByLower;
    private JRadioButton thresholdByUpper;

    public ThresholdControlUI(PipeLineManager pipeLineManager, ThresholdPlugin plugin, Frame owner) {
        super(owner, "Threshold configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), plugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener((ActionListener)((Object)this));
        line.add((Component)this.inputDataset, "Center");
        line.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel(new GridLayout(2, 2));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Levels"));
        this.lowerLevel = new JFormattedTextField((Object)"0");
        this.lowerLevel.setValue(new Double(-1.0));
        this.upperLevel = new JFormattedTextField((Object)"0");
        this.upperLevel.setValue(new Double(1.0));
        line.add(new JLabel("Lower level"));
        line.add(new JLabel("Upper level"));
        line.add(this.lowerLevel);
        line.add(this.upperLevel);
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel(new GridLayout(3, 1));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Threshold type"));
        ButtonGroup group = new ButtonGroup();
        this.thresholdBetween = new JRadioButton("Threshold between", true);
        this.thresholdByLower = new JRadioButton("Threshold by lower", false);
        this.thresholdByUpper = new JRadioButton("Threshold by upper", false);
        group.add(this.thresholdBetween);
        group.add(this.thresholdByLower);
        group.add(this.thresholdByUpper);
        line.add(this.thresholdBetween);
        line.add(this.thresholdByLower);
        line.add(this.thresholdByUpper);
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel();
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        this.getContentPane().add(line);
        this.pack();
        Dimension d = this.getSize();
        this.setSize(300, d.height);
        this.setLocationRelativeTo(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        boolean levelFlag = false;
        if (command.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(new JFrame(), "Please select a valid input dataset.", "Input Filter Selection Error", 0);
                return;
            }
            int thresholdType = 0;
            if (this.thresholdBetween.isSelected()) {
                thresholdType = 1;
            }
            if (this.thresholdByLower.isSelected()) {
                thresholdType = 2;
            }
            if (this.thresholdByUpper.isSelected()) {
                thresholdType = 3;
            }
            this.plugin.updateThreshold((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject(), thresholdType, ((Number)this.lowerLevel.getValue()).doubleValue(), ((Number)this.upperLevel.getValue()).doubleValue());
            this.pipeLineManager.validateViewAndGo();
            return;
        }
        if (command.equals("CANCEL")) {
            this.dispose();
            return;
        }
        if (this.datasetModel.getSelectedItem() == null) return;
        double[] range = ((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject()).GetScalarRange();
        if (range == null) return;
        this.lowerLevel.setValue(new Double(range[0]));
        this.upperLevel.setValue(new Double(range[1]));
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public void itemStateChanged(ItemEvent arg0) {
    }
}

