/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.IConfigurableLookupTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ColorXMLWriter {
    private static final String ELEM_BEGIN_START = "<";
    private static final String ELEM_BEGIN_END = "</";
    private static final String ELEM_END = ">\n";
    private static final String ELEM_END_END = "/>\n";
    private static final String SPACE = " ";
    private static final String INDENT = "   ";
    private BufferedWriter writer;
    private IConfigurableLookupTable lookupTable;

    public void writeTo(File file, IConfigurableLookupTable aLookupTable) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
        this.lookupTable = aLookupTable;
        this.writeTo();
        this.writer.close();
    }

    private void writeTo() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write(ELEM_BEGIN_START);
        this.writer.write("Gradient");
        this.writer.write(SPACE);
        this.writeAttribute("startColor", this.lookupTable.getColorCodeAt(0));
        this.writer.write(SPACE);
        this.writeAttribute("endColor", this.lookupTable.getColorCodeAt(this.lookupTable.getNbColors() - 1));
        this.writer.write(SPACE);
        this.writeAttribute("nbColors", String.valueOf(this.lookupTable.getNbColors()));
        this.writer.write(ELEM_END);
        for (Integer i : this.lookupTable.getColorPositionsMap().keySet()) {
            if (i == 0 || i == this.lookupTable.getNbColors() - 1) continue;
            this.writer.write(INDENT);
            this.writer.write(ELEM_BEGIN_START);
            this.writer.write("Color");
            this.writer.write(SPACE);
            this.writeAttribute("position", String.valueOf(i));
            this.writer.write(SPACE);
            this.writeAttribute("code", this.lookupTable.getColorCodeAt(i));
            this.writer.write(ELEM_END_END);
        }
        this.writer.write(ELEM_BEGIN_END);
        this.writer.write("Gradient");
        this.writer.write(ELEM_END);
        this.writer.flush();
    }

    private void writeAttribute(String attributeName, String value) throws IOException {
        this.writer.write(attributeName);
        this.writer.write("=\"");
        this.writer.write(value);
        this.writer.write("\"");
    }
}

